/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.actionlog.LogDispatcher;
import me.lucko.luckperms.common.api.ApiRegistrationUtil;
import me.lucko.luckperms.common.api.LuckPermsApiProvider;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.config.LuckPermsConfiguration;
import me.lucko.luckperms.common.config.generic.adapter.ConfigurationAdapter;
import me.lucko.luckperms.common.config.generic.adapter.EnvironmentVariableConfigAdapter;
import me.lucko.luckperms.common.config.generic.adapter.FileSecretConfigAdapter;
import me.lucko.luckperms.common.config.generic.adapter.MultiConfigurationAdapter;
import me.lucko.luckperms.common.config.generic.adapter.SystemPropertyConfigAdapter;
import me.lucko.luckperms.common.context.calculator.ConfigurationContextCalculator;
import me.lucko.luckperms.common.dependencies.Dependency;
import me.lucko.luckperms.common.dependencies.DependencyManager;
import me.lucko.luckperms.common.dependencies.DependencyManagerImpl;
import me.lucko.luckperms.common.event.AbstractEventBus;
import me.lucko.luckperms.common.event.EventDispatcher;
import me.lucko.luckperms.common.event.gen.GeneratedEventClass;
import me.lucko.luckperms.common.extension.SimpleExtensionManager;
import me.lucko.luckperms.common.http.BytebinClient;
import me.lucko.luckperms.common.http.BytesocksClient;
import me.lucko.luckperms.common.inheritance.InheritanceGraphFactory;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.locale.TranslationRepository;
import me.lucko.luckperms.common.messaging.InternalMessagingService;
import me.lucko.luckperms.common.messaging.MessagingFactory;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.plugin.util.HealthCheckResult;
import me.lucko.luckperms.common.storage.Storage;
import me.lucko.luckperms.common.storage.StorageFactory;
import me.lucko.luckperms.common.storage.StorageMetadata;
import me.lucko.luckperms.common.storage.implementation.file.watcher.FileWatcher;
import me.lucko.luckperms.common.storage.misc.DataConstraints;
import me.lucko.luckperms.common.tasks.CacheHousekeepingTask;
import me.lucko.luckperms.common.tasks.ExpireTemporaryTask;
import me.lucko.luckperms.common.tasks.SyncTask;
import me.lucko.luckperms.common.treeview.AsyncPermissionRegistry;
import me.lucko.luckperms.common.treeview.PermissionRegistry;
import me.lucko.luckperms.common.verbose.VerboseHandler;
import me.lucko.luckperms.common.webeditor.socket.WebEditorSocket;
import me.lucko.luckperms.common.webeditor.store.WebEditorStore;
import me.lucko.luckperms.lib.okhttp3.OkHttpClient;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.platform.Health;

public abstract class AbstractLuckPermsPlugin
implements LuckPermsPlugin {
    private DependencyManager dependencyManager;
    private TranslationManager translationManager;
    private AsyncPermissionRegistry permissionRegistry;
    private VerboseHandler verboseHandler;
    private LogDispatcher logDispatcher;
    private LuckPermsConfiguration configuration;
    private OkHttpClient httpClient;
    private BytebinClient bytebin;
    private BytesocksClient bytesocks;
    private WebEditorStore webEditorStore;
    private TranslationRepository translationRepository;
    private FileWatcher fileWatcher = null;
    private Storage storage;
    private InternalMessagingService messagingService = null;
    private SyncTask.Buffer syncTaskBuffer;
    private InheritanceGraphFactory inheritanceGraphFactory;
    private CalculatorFactory calculatorFactory;
    private LuckPermsApiProvider apiProvider;
    private EventDispatcher eventDispatcher;
    private SimpleExtensionManager extensionManager;
    private boolean running = false;

    public final void load() {
        this.dependencyManager = this.createDependencyManager();
        this.dependencyManager.loadDependencies(this.getGlobalDependencies());
        this.translationManager = new TranslationManager(this);
        this.translationManager.reload();
        this.permissionRegistry = new AsyncPermissionRegistry(this.getBootstrap().getScheduler());
        this.verboseHandler = new VerboseHandler(this.getBootstrap().getScheduler());
        this.getLogger().info("Loading configuration...");
        ConfigurationAdapter configFileAdapter = this.provideConfigurationAdapter();
        this.configuration = new LuckPermsConfiguration(this, new MultiConfigurationAdapter((LuckPermsPlugin)this, new FileSecretConfigAdapter(this), new SystemPropertyConfigAdapter(this), new EnvironmentVariableConfigAdapter(this), configFileAdapter));
    }

    public final void enable() {
        this.setupSenderFactory();
        Message.STARTUP_BANNER.send(this.getConsoleSender(), this.getBootstrap());
        this.logDispatcher = new LogDispatcher(this);
        this.httpClient = new OkHttpClient.Builder().callTimeout(15L, TimeUnit.SECONDS).build();
        this.bytebin = new BytebinClient(this.httpClient, this.getConfiguration().get(ConfigKeys.BYTEBIN_URL), "luckperms");
        this.bytesocks = new BytesocksClient(this.httpClient, this.getConfiguration().get(ConfigKeys.BYTESOCKS_HOST), this.getConfiguration().get(ConfigKeys.BYTESOCKS_USE_TLS), "luckperms/editor");
        this.webEditorStore = new WebEditorStore(this);
        this.translationRepository = new TranslationRepository(this);
        this.translationRepository.scheduleRefresh();
        StorageFactory storageFactory = new StorageFactory(this);
        this.dependencyManager.loadStorageDependencies(storageFactory.getRequiredTypes(), this.getConfiguration().get(ConfigKeys.REDIS_ENABLED), this.getConfiguration().get(ConfigKeys.RABBITMQ_ENABLED), this.getConfiguration().get(ConfigKeys.NATS_ENABLED));
        this.registerPlatformListeners();
        if (this.getConfiguration().get(ConfigKeys.WATCH_FILES).booleanValue()) {
            try {
                this.fileWatcher = new FileWatcher(this, this.getBootstrap().getDataDirectory());
            }
            catch (Throwable e) {
                this.getLogger().warn("Error occurred whilst trying to create a file watcher:", e);
            }
        }
        this.storage = storageFactory.getInstance();
        this.messagingService = this.provideMessagingFactory().getInstance();
        this.syncTaskBuffer = new SyncTask.Buffer(this);
        if (this.skipCommandRegistration()) {
            this.getLogger().warn("LuckPerms commands are disabled in the configuration for both console and players. Skipping command registration.");
        } else {
            this.registerCommands();
        }
        this.getLogger().info("Loading internal permission managers...");
        this.inheritanceGraphFactory = new InheritanceGraphFactory(this);
        this.setupManagers();
        this.calculatorFactory = this.provideCalculatorFactory();
        this.setupContextManager();
        this.getContextManager().registerCalculator(new ConfigurationContextCalculator(this.getConfiguration()));
        this.setupPlatformHooks();
        this.apiProvider = new LuckPermsApiProvider(this);
        this.apiProvider.ensureApiWasLoadedByPlugin();
        this.eventDispatcher = new EventDispatcher(this.provideEventBus(this.apiProvider));
        this.getBootstrap().getScheduler().executeAsync(GeneratedEventClass::preGenerate);
        ApiRegistrationUtil.registerProvider(this.apiProvider);
        this.registerApiOnPlatform(this.apiProvider);
        this.extensionManager = new SimpleExtensionManager(this);
        this.extensionManager.loadExtensions(this.getBootstrap().getConfigDirectory().resolve("extensions"));
        int syncMins = this.getConfiguration().get(ConfigKeys.SYNC_TIME);
        if (syncMins > 0) {
            this.getBootstrap().getScheduler().asyncRepeating(() -> this.syncTaskBuffer.request(), syncMins, TimeUnit.MINUTES);
        }
        this.getLogger().info("Performing initial data load...");
        try {
            new SyncTask(this).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.registerHousekeepingTasks();
        this.performFinalSetup();
        this.running = true;
        Duration timeTaken = Duration.between(this.getBootstrap().getStartupTime(), Instant.now());
        this.getLogger().info("Successfully enabled. (took " + timeTaken.toMillis() + "ms)");
    }

    public final void disable() {
        this.getLogger().info("Starting shutdown process...");
        this.getBootstrap().getScheduler().shutdownScheduler();
        for (WebEditorSocket socket : this.webEditorStore.sockets().getSockets()) {
            if (socket.isClosed()) continue;
            socket.close();
        }
        this.permissionRegistry.close();
        this.verboseHandler.close();
        this.extensionManager.close();
        this.running = false;
        this.removePlatformHooks();
        if (this.messagingService != null) {
            this.getLogger().info("Closing messaging service...");
            this.messagingService.close();
        }
        this.getLogger().info("Closing storage...");
        this.storage.shutdown();
        if (this.fileWatcher != null) {
            this.fileWatcher.close();
        }
        ApiRegistrationUtil.unregisterProvider();
        this.getBootstrap().getScheduler().shutdownExecutor();
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
        this.getDependencyManager().close();
        this.getBootstrap().getClassPathAppender().close();
        this.getLogger().info("Goodbye!");
    }

    protected DependencyManager createDependencyManager() {
        return new DependencyManagerImpl(this);
    }

    protected Set<Dependency> getGlobalDependencies() {
        return EnumSet.of(Dependency.ADVENTURE, new Dependency[]{Dependency.CAFFEINE, Dependency.OKIO, Dependency.OKHTTP, Dependency.BYTEBUDDY, Dependency.EVENT});
    }

    protected void registerHousekeepingTasks() {
        this.getBootstrap().getScheduler().asyncRepeating(new ExpireTemporaryTask(this), 3L, TimeUnit.SECONDS);
        this.getBootstrap().getScheduler().asyncRepeating(new CacheHousekeepingTask(this), 2L, TimeUnit.MINUTES);
    }

    protected abstract void setupSenderFactory();

    protected abstract ConfigurationAdapter provideConfigurationAdapter();

    protected abstract void registerPlatformListeners();

    protected abstract MessagingFactory<?> provideMessagingFactory();

    protected abstract void registerCommands();

    protected abstract void setupManagers();

    protected abstract CalculatorFactory provideCalculatorFactory();

    protected abstract void setupContextManager();

    protected abstract void setupPlatformHooks();

    protected abstract AbstractEventBus<?> provideEventBus(LuckPermsApiProvider var1);

    protected abstract void registerApiOnPlatform(LuckPerms var1);

    protected abstract void performFinalSetup();

    protected void removePlatformHooks() {
    }

    protected Path resolveConfig(String fileName) {
        Path configFile = this.getBootstrap().getConfigDirectory().resolve(fileName);
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try (InputStream is = this.getBootstrap().getResourceStream(fileName);){
                Files.copy(is, configFile, new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return configFile;
    }

    protected boolean skipCommandRegistration() {
        return this.getConfiguration().get(ConfigKeys.DISABLE_LUCKPERMS_COMMANDS_CONSOLE) != false && this.getConfiguration().get(ConfigKeys.DISABLE_LUCKPERMS_COMMANDS_PLAYERS) != false;
    }

    @Override
    public PluginLogger getLogger() {
        return this.getBootstrap().getPluginLogger();
    }

    @Override
    public void setMessagingService(InternalMessagingService messagingService) {
        if (this.messagingService == null) {
            this.messagingService = messagingService;
        }
    }

    @Override
    public Health runHealthCheck() {
        if (!this.running) {
            return HealthCheckResult.unhealthy(Collections.emptyMap());
        }
        StorageMetadata meta = this.storage.getMeta();
        if (meta.connected() != null && !meta.connected().booleanValue()) {
            return HealthCheckResult.unhealthy(Collections.singletonMap("reason", "storage disconnected"));
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (meta.connected() != null) {
            map.put("storageConnected", meta.connected());
        }
        if (meta.ping() != null) {
            map.put("storagePing", meta.ping());
        }
        if (meta.sizeBytes() != null) {
            map.put("storageSizeBytes", meta.sizeBytes());
        }
        return HealthCheckResult.healthy(map);
    }

    @Override
    public Optional<UUID> lookupUniqueId(String username) {
        UUID uniqueId = this.getStorage().getPlayerUniqueId(username.toLowerCase(Locale.ROOT)).join();
        uniqueId = this.getEventDispatcher().dispatchUniqueIdLookup(username, uniqueId);
        if (uniqueId == null && this.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue()) {
            uniqueId = this.getBootstrap().lookupUniqueId(username).orElse(null);
        }
        return Optional.ofNullable(uniqueId);
    }

    @Override
    public Optional<String> lookupUsername(UUID uniqueId) {
        String username = this.getStorage().getPlayerName(uniqueId).join();
        username = this.getEventDispatcher().dispatchUsernameLookup(uniqueId, username);
        if (username == null && this.getConfiguration().get(ConfigKeys.USE_SERVER_UUID_CACHE).booleanValue()) {
            username = this.getBootstrap().lookupUsername(uniqueId).orElse(null);
        }
        return Optional.ofNullable(username);
    }

    @Override
    public boolean testUsernameValidity(String username) {
        if (!DataConstraints.PLAYER_USERNAME_TEST_LENIENT.test(username)) {
            return false;
        }
        boolean valid = this.getConfiguration().get(ConfigKeys.ALLOW_INVALID_USERNAMES) != false || DataConstraints.PLAYER_USERNAME_TEST.test(username);
        return this.getEventDispatcher().dispatchUsernameValidityCheck(username, valid);
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public TranslationManager getTranslationManager() {
        return this.translationManager;
    }

    @Override
    public VerboseHandler getVerboseHandler() {
        return this.verboseHandler;
    }

    @Override
    public PermissionRegistry getPermissionRegistry() {
        return this.permissionRegistry;
    }

    @Override
    public LogDispatcher getLogDispatcher() {
        return this.logDispatcher;
    }

    @Override
    public LuckPermsConfiguration getConfiguration() {
        return this.configuration;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public BytebinClient getBytebin() {
        return this.bytebin;
    }

    @Override
    public BytesocksClient getBytesocks() {
        return this.bytesocks;
    }

    @Override
    public WebEditorStore getWebEditorStore() {
        return this.webEditorStore;
    }

    @Override
    public TranslationRepository getTranslationRepository() {
        return this.translationRepository;
    }

    @Override
    public Optional<FileWatcher> getFileWatcher() {
        return Optional.ofNullable(this.fileWatcher);
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public Optional<InternalMessagingService> getMessagingService() {
        return Optional.ofNullable(this.messagingService);
    }

    @Override
    public SyncTask.Buffer getSyncTaskBuffer() {
        return this.syncTaskBuffer;
    }

    @Override
    public InheritanceGraphFactory getInheritanceGraphFactory() {
        return this.inheritanceGraphFactory;
    }

    @Override
    public CalculatorFactory getCalculatorFactory() {
        return this.calculatorFactory;
    }

    @Override
    public LuckPermsApiProvider getApiProvider() {
        return this.apiProvider;
    }

    @Override
    public SimpleExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public static String getPluginName() {
        LocalDate date = LocalDate.now();
        if (date.getMonth() == Month.APRIL && date.getDayOfMonth() == 1) {
            return "LuckyPerms";
        }
        return "LuckPerms";
    }
}

