/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.query;

import java.util.EnumSet;
import java.util.Set;
import net.luckperms.api.query.Flag;

final class FlagUtils {
    private static final EnumSet<Flag> ALL_FLAGS_SET = EnumSet.allOf(Flag.class);
    private static final int ALL_FLAGS_SIZE = ALL_FLAGS_SET.size();
    static final byte ALL_FLAGS = FlagUtils.toByte0(ALL_FLAGS_SET);

    private FlagUtils() {
    }

    static boolean read(byte b, Flag setting) {
        return (b >> setting.ordinal() & 1) == 1;
    }

    static byte toByte(Set<Flag> settings) {
        if (settings.size() == ALL_FLAGS_SIZE) {
            return ALL_FLAGS;
        }
        return FlagUtils.toByte0(settings);
    }

    private static byte toByte0(Set<Flag> settings) {
        byte b = 0;
        for (Flag setting : settings) {
            b = (byte)(b | (byte)(1 << setting.ordinal()));
        }
        return b;
    }

    static Set<Flag> toSet(byte b) {
        EnumSet<Flag> settings = EnumSet.noneOf(Flag.class);
        for (Flag setting : Flag.values()) {
            if (!FlagUtils.read(b, setting)) continue;
            settings.add(setting);
        }
        return settings;
    }
}

