/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.sender;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.JoinConfiguration;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import net.luckperms.api.util.Tristate;

public final class AbstractSender<T>
implements Sender {
    private final LuckPermsPlugin plugin;
    private final SenderFactory<?, T> factory;
    private final T sender;
    private final UUID uniqueId;
    private final String name;
    private final boolean isConsole;

    AbstractSender(LuckPermsPlugin plugin, SenderFactory<?, T> factory, T sender) {
        this.plugin = plugin;
        this.factory = factory;
        this.sender = sender;
        this.uniqueId = factory.getUniqueId(this.sender);
        this.name = factory.getName(this.sender);
        this.isConsole = this.factory.isConsole(this.sender);
    }

    @Override
    public LuckPermsPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void sendMessage(Component message) {
        if (this.factory.shouldSplitNewlines(this.sender)) {
            for (Component line : AbstractSender.splitNewlines(message)) {
                this.factory.sendMessage(this.sender, line);
            }
        } else {
            this.factory.sendMessage(this.sender, message);
        }
    }

    @Override
    public Tristate getPermissionValue(String permission) {
        return this.isConsole() ? Tristate.TRUE : this.factory.getPermissionValue(this.sender, permission);
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.isConsole() || this.factory.hasPermission(this.sender, permission);
    }

    @Override
    public boolean hasPermission(CommandPermission permission) {
        boolean readOnlyMode;
        boolean bl = readOnlyMode = this.isConsole() ? this.plugin.getConfiguration().get(ConfigKeys.READ_ONLY_MODE_CONSOLE).booleanValue() : this.plugin.getConfiguration().get(ConfigKeys.READ_ONLY_MODE_PLAYERS).booleanValue();
        if (readOnlyMode && !permission.isReadOnly()) {
            return false;
        }
        return this.hasPermission(permission.getPermission());
    }

    @Override
    public void performCommand(String commandLine) {
        this.factory.performCommand(this.sender, commandLine);
    }

    @Override
    public boolean isConsole() {
        return this.isConsole;
    }

    @Override
    public boolean isValid() {
        return this.isConsole() || this.plugin.getBootstrap().isPlayerOnline(this.uniqueId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSender)) {
            return false;
        }
        AbstractSender that = (AbstractSender)o;
        return this.getUniqueId().equals(that.getUniqueId());
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public static Iterable<Component> splitNewlines(Component message) {
        if (message instanceof TextComponent && message.style().isEmpty() && !message.children().isEmpty() && ((TextComponent)message).content().isEmpty()) {
            LinkedList split = new LinkedList();
            split.add(new ArrayList());
            for (Component child : message.children()) {
                if (Component.newline().equals((Object)child)) {
                    split.add(new ArrayList());
                    continue;
                }
                Iterator<Component> splitChildren = AbstractSender.splitNewlines(child).iterator();
                if (splitChildren.hasNext()) {
                    ((List)split.getLast()).add(splitChildren.next());
                }
                while (splitChildren.hasNext()) {
                    split.add(new ArrayList());
                    ((List)split.getLast()).add(splitChildren.next());
                }
            }
            return Iterables.transform(split, input -> {
                switch (input.size()) {
                    case 0: {
                        return Component.empty();
                    }
                    case 1: {
                        return (Component)input.get(0);
                    }
                }
                return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.empty()), (Iterable)input);
            });
        }
        return Collections.singleton(message);
    }
}

