/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.lucko.luckperms.common.bulkupdate.BulkUpdate;
import me.lucko.luckperms.common.model.HolderType;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.matcher.ConstraintNodeMatcher;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.file.AbstractConfigurateStorage;
import me.lucko.luckperms.common.storage.implementation.file.FileIOException;
import me.lucko.luckperms.common.storage.implementation.file.StorageLocation;
import me.lucko.luckperms.common.storage.implementation.file.loader.ConfigurateLoader;
import me.lucko.luckperms.common.storage.implementation.file.watcher.FileWatcher;
import me.lucko.luckperms.common.storage.misc.NodeEntry;
import me.lucko.luckperms.common.util.CaffeineFactory;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.common.util.MoreFiles;
import me.lucko.luckperms.common.util.Uuids;
import me.lucko.luckperms.lib.caffeine.cache.LoadingCache;
import me.lucko.luckperms.lib.configurate.ConfigurationNode;
import net.luckperms.api.node.Node;

public class SeparatedConfigurateStorage
extends AbstractConfigurateStorage {
    private final String fileExtension;
    private final Predicate<Path> fileExtensionFilter;
    private final Map<StorageLocation, FileGroup> fileGroups;
    private final FileGroup users;
    private final FileGroup groups;
    private final FileGroup tracks;
    private final LoadingCache<Path, ReentrantLock> ioLocks;

    public SeparatedConfigurateStorage(LuckPermsPlugin plugin, String implementationName, ConfigurateLoader loader, String fileExtension, String dataFolderName) {
        super(plugin, implementationName, loader, dataFolderName);
        this.fileExtension = fileExtension;
        this.fileExtensionFilter = path -> path.getFileName().toString().endsWith(this.fileExtension);
        this.users = new FileGroup();
        this.groups = new FileGroup();
        this.tracks = new FileGroup();
        EnumMap<StorageLocation, FileGroup> fileGroups = new EnumMap<StorageLocation, FileGroup>(StorageLocation.class);
        fileGroups.put(StorageLocation.USERS, this.users);
        fileGroups.put(StorageLocation.GROUPS, this.groups);
        fileGroups.put(StorageLocation.TRACKS, this.tracks);
        this.fileGroups = ImmutableMap.copyOf(fileGroups);
        this.ioLocks = CaffeineFactory.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build(key -> new ReentrantLock());
    }

    @Override
    protected ConfigurationNode readFile(StorageLocation location, String name) throws IOException {
        Path file = this.getDirectory(location).resolve(name + this.fileExtension);
        this.registerFileAction(location, file);
        return this.readFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationNode readFile(Path file) throws IOException {
        ReentrantLock lock = Objects.requireNonNull((ReentrantLock)this.ioLocks.get((Object)file));
        lock.lock();
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                ConfigurationNode configurationNode = null;
                return configurationNode;
            }
            ConfigurationNode configurationNode = this.loader.loader(file).load();
            return configurationNode;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void saveFile(StorageLocation location, String name, ConfigurationNode node) throws IOException {
        Path file = this.getDirectory(location).resolve(name + this.fileExtension);
        this.registerFileAction(location, file);
        this.saveFile(file, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(Path file, ConfigurationNode node) throws IOException {
        ReentrantLock lock = Objects.requireNonNull((ReentrantLock)this.ioLocks.get((Object)file));
        lock.lock();
        try {
            if (node == null) {
                Files.deleteIfExists(file);
                return;
            }
            this.loader.loader(file).save(node);
        }
        finally {
            lock.unlock();
        }
    }

    private Path getDirectory(StorageLocation location) {
        return this.fileGroups.get((Object)((Object)location)).directory;
    }

    private void registerFileAction(StorageLocation type, Path file) {
        FileWatcher.WatchedLocation watcher = this.fileGroups.get((Object)((Object)type)).watcher;
        if (watcher != null) {
            watcher.recordChange(file.getFileName().toString());
        }
    }

    @Override
    public void init() throws IOException {
        super.init();
        this.users.directory = MoreFiles.createDirectoryIfNotExists(this.dataDirectory.resolve("users"));
        this.groups.directory = MoreFiles.createDirectoryIfNotExists(this.dataDirectory.resolve("groups"));
        this.tracks.directory = MoreFiles.createDirectoryIfNotExists(this.dataDirectory.resolve("tracks"));
        FileWatcher watcher = this.plugin.getFileWatcher().orElse(null);
        if (watcher != null) {
            this.users.watcher = watcher.getWatcher(this.users.directory);
            this.users.watcher.addListener(path -> {
                String fileName = path.getFileName().toString();
                if (!fileName.endsWith(this.fileExtension)) {
                    return;
                }
                String user = fileName.substring(0, fileName.length() - this.fileExtension.length());
                UUID uuid = Uuids.parse(user);
                if (uuid == null) {
                    return;
                }
                User u = (User)this.plugin.getUserManager().getIfLoaded(uuid);
                if (u != null) {
                    this.plugin.getLogger().info("[FileWatcher] Detected change in user file for " + u.getPlainDisplayName() + " - reloading...");
                    this.plugin.getStorage().loadUser(uuid, null);
                }
            });
            this.groups.watcher = watcher.getWatcher(this.groups.directory);
            this.groups.watcher.addListener(path -> {
                String fileName = path.getFileName().toString();
                if (!fileName.endsWith(this.fileExtension)) {
                    return;
                }
                String groupName = fileName.substring(0, fileName.length() - this.fileExtension.length());
                this.plugin.getLogger().info("[FileWatcher] Detected change in group file for " + groupName + " - reloading...");
                this.plugin.getSyncTaskBuffer().request();
            });
            this.tracks.watcher = watcher.getWatcher(this.tracks.directory);
            this.tracks.watcher.addListener(path -> {
                String fileName = path.getFileName().toString();
                if (!fileName.endsWith(this.fileExtension)) {
                    return;
                }
                String trackName = fileName.substring(0, fileName.length() - this.fileExtension.length());
                this.plugin.getLogger().info("[FileWatcher] Detected change in track file for " + trackName + " - reloading...");
                this.plugin.getStorage().loadAllTracks();
            });
        }
    }

    @Override
    public void applyBulkUpdate(BulkUpdate bulkUpdate) throws Exception {
        Stream<Path> s;
        if (bulkUpdate.getDataType().isIncludingUsers()) {
            s = Files.list(this.getDirectory(StorageLocation.USERS));
            try {
                s.filter(this.fileExtensionFilter).forEach(file -> {
                    try {
                        this.registerFileAction(StorageLocation.USERS, (Path)file);
                        ConfigurationNode object = this.readFile((Path)file);
                        if (this.processBulkUpdate(bulkUpdate, object, HolderType.USER)) {
                            this.saveFile((Path)file, object);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Exception whilst performing bulkupdate", new FileIOException(file.getFileName().toString(), e));
                    }
                });
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        if (bulkUpdate.getDataType().isIncludingGroups()) {
            s = Files.list(this.getDirectory(StorageLocation.GROUPS));
            try {
                s.filter(this.fileExtensionFilter).forEach(file -> {
                    try {
                        this.registerFileAction(StorageLocation.GROUPS, (Path)file);
                        ConfigurationNode object = this.readFile((Path)file);
                        if (this.processBulkUpdate(bulkUpdate, object, HolderType.GROUP)) {
                            this.saveFile((Path)file, object);
                        }
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().severe("Exception whilst performing bulkupdate", new FileIOException(file.getFileName().toString(), e));
                    }
                });
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
    }

    @Override
    public Set<UUID> getUniqueUsers() throws IOException {
        try (Stream<Path> stream = Files.list(this.users.directory);){
            Set<UUID> set = stream.filter(this.fileExtensionFilter).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - this.fileExtension.length())).map(Uuids::fromString).filter(Objects::nonNull).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public <N extends Node> List<NodeEntry<UUID, N>> searchUserNodes(ConstraintNodeMatcher<N> constraint) throws IOException {
        ArrayList held = new ArrayList();
        try (Stream<Path> stream = Files.list(this.getDirectory(StorageLocation.USERS));){
            stream.filter(this.fileExtensionFilter).forEach(file -> {
                String fileName = file.getFileName().toString();
                try {
                    this.registerFileAction(StorageLocation.USERS, (Path)file);
                    ConfigurationNode object = this.readFile((Path)file);
                    UUID holder = UUID.fromString(fileName.substring(0, fileName.length() - this.fileExtension.length()));
                    Set<Node> nodes = SeparatedConfigurateStorage.readNodes(object);
                    for (Node e : nodes) {
                        Object match = constraint.match(e);
                        if (match == null) continue;
                        held.add(NodeEntry.of(holder, match));
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Exception whilst searching user nodes", new FileIOException(file.getFileName().toString(), e));
                }
            });
        }
        return held;
    }

    @Override
    public void loadAllGroups() throws IOException {
        List groups;
        try (Stream<Path> stream = Files.list(this.groups.directory);){
            groups = stream.filter(this.fileExtensionFilter).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - this.fileExtension.length())).collect(Collectors.toList());
        }
        if (!Iterators.tryIterate(groups, this::loadGroup)) {
            throw new RuntimeException("Exception occurred whilst loading a group");
        }
        this.plugin.getGroupManager().retainAll(groups);
    }

    @Override
    public <N extends Node> List<NodeEntry<String, N>> searchGroupNodes(ConstraintNodeMatcher<N> constraint) throws IOException {
        ArrayList held = new ArrayList();
        try (Stream<Path> stream = Files.list(this.getDirectory(StorageLocation.GROUPS));){
            stream.filter(this.fileExtensionFilter).forEach(file -> {
                String fileName = file.getFileName().toString();
                try {
                    this.registerFileAction(StorageLocation.GROUPS, (Path)file);
                    ConfigurationNode object = this.readFile((Path)file);
                    String holder = fileName.substring(0, fileName.length() - this.fileExtension.length());
                    Set<Node> nodes = SeparatedConfigurateStorage.readNodes(object);
                    for (Node e : nodes) {
                        Object match = constraint.match(e);
                        if (match == null) continue;
                        held.add(NodeEntry.of(holder, match));
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Exception whilst searching group nodes", new FileIOException(file.getFileName().toString(), e));
                }
            });
        }
        return held;
    }

    @Override
    public void loadAllTracks() throws IOException {
        List tracks;
        try (Stream<Path> stream = Files.list(this.tracks.directory);){
            tracks = stream.filter(this.fileExtensionFilter).map(p -> p.getFileName().toString()).map(s -> s.substring(0, s.length() - this.fileExtension.length())).collect(Collectors.toList());
        }
        if (!Iterators.tryIterate(tracks, this::loadTrack)) {
            throw new RuntimeException("Exception occurred whilst loading a track");
        }
        this.plugin.getTrackManager().retainAll(tracks);
    }

    private static final class FileGroup {
        private Path directory;
        private FileWatcher.WatchedLocation watcher;

        private FileGroup() {
        }
    }
}

