/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.ComponentLike;
import me.lucko.luckperms.lib.adventure.text.TextComponent;
import me.lucko.luckperms.lib.adventure.text.TranslatableComponent;
import me.lucko.luckperms.lib.adventure.text.serializer.plain.PlainTextComponentSerializer;

public class DurationFormatter {
    public static final DurationFormatter LONG = new DurationFormatter(false);
    public static final DurationFormatter CONCISE = new DurationFormatter(true);
    public static final DurationFormatter CONCISE_LOW_ACCURACY = new DurationFormatter(true, 3);
    private static final ChronoUnit[] UNITS = new ChronoUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.WEEKS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS};
    private final boolean concise;
    private final int accuracy;

    public DurationFormatter(boolean concise) {
        this(concise, Integer.MAX_VALUE);
    }

    public DurationFormatter(boolean concise, int accuracy) {
        this.concise = concise;
        this.accuracy = accuracy;
    }

    public String formatString(Duration duration) {
        return PlainTextComponentSerializer.plainText().serialize(TranslationManager.render(this.format(duration)));
    }

    public Component format(Duration duration) {
        long seconds = duration.getSeconds();
        TextComponent.Builder builder = Component.text();
        int outputSize = 0;
        for (ChronoUnit unit : UNITS) {
            long n = seconds / unit.getDuration().getSeconds();
            if (n > 0L) {
                seconds -= unit.getDuration().getSeconds() * n;
                if (outputSize != 0) {
                    builder.append((Component)Component.space());
                }
                builder.append((Component)this.formatPart(n, unit));
                ++outputSize;
            }
            if (seconds <= 0L || outputSize >= this.accuracy) break;
        }
        if (outputSize == 0) {
            return this.formatPart(0L, ChronoUnit.SECONDS);
        }
        return builder.build();
    }

    private TranslatableComponent formatPart(long amount, ChronoUnit unit) {
        String format = this.concise ? "short" : (amount == 1L ? "singular" : "plural");
        String translationKey = "luckperms.duration.unit." + unit.name().toLowerCase(Locale.ROOT) + "." + format;
        return Component.translatable((String)translationKey, (ComponentLike[])new ComponentLike[]{Component.text((long)amount)});
    }
}

