/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import me.lucko.luckperms.common.verbose.InvalidFilterException;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.common.verbose.expression.BooleanExpressionCompiler;

public final class VerboseFilter {
    private final String expression;
    private final BooleanExpressionCompiler.AST ast;

    public static VerboseFilter acceptAll() {
        return new VerboseFilter("", BooleanExpressionCompiler.AST.ALWAYS_TRUE);
    }

    public static VerboseFilter compile(String expression) throws InvalidFilterException {
        if (expression.isEmpty()) {
            return VerboseFilter.acceptAll();
        }
        try {
            return new VerboseFilter(expression, BooleanExpressionCompiler.compile(expression));
        }
        catch (BooleanExpressionCompiler.LexerException | BooleanExpressionCompiler.ParserException e) {
            throw new InvalidFilterException("Exception occurred whilst generating an expression for '" + expression + "'", e);
        }
    }

    private VerboseFilter(String expression, BooleanExpressionCompiler.AST ast) {
        this.expression = expression;
        this.ast = ast;
    }

    public boolean evaluate(VerboseEvent data) {
        try {
            return this.ast.eval(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isBlank() {
        return this.ast == BooleanExpressionCompiler.AST.ALWAYS_TRUE;
    }

    public String toString() {
        return this.isBlank() ? "any" : this.expression;
    }
}

