/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.event;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Locale;
import me.lucko.luckperms.common.cacheddata.result.StringResult;
import me.lucko.luckperms.common.node.utils.NodeJsonSerializer;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.VerboseCheckTarget;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.common.verbose.event.VerboseEvent;
import me.lucko.luckperms.common.verbose.event.VerboseEventType;
import net.luckperms.api.query.QueryOptions;

public class MetaCheckEvent
extends VerboseEvent {
    private final String key;
    private final StringResult<?> result;

    public MetaCheckEvent(CheckOrigin origin, VerboseCheckTarget checkTarget, QueryOptions checkQueryOptions, long checkTime, Throwable checkTrace, String checkThread, String key, StringResult<?> result) {
        super(origin, checkTarget, checkQueryOptions, checkTime, checkTrace, checkThread);
        this.key = key;
        this.result = result;
    }

    public String getKey() {
        return this.key;
    }

    public StringResult<?> getResult() {
        return this.result;
    }

    @Override
    public VerboseEventType getType() {
        return VerboseEventType.META;
    }

    @Override
    protected void serializeTo(JObject object) {
        object.add("key", this.key);
        object.add("result", String.valueOf(this.result.result()));
        if (this.result != StringResult.nullResult()) {
            object.add("resultInfo", MetaCheckEvent.serializeResult(this.result));
        }
    }

    private static JObject serializeResult(StringResult<?> result) {
        JObject object = new JObject();
        object.add("result", String.valueOf(result.result()));
        if (result.node() != null) {
            object.add("node", (JsonElement)NodeJsonSerializer.serializeNode(result.node(), true));
        }
        if (result.overriddenResult() != null) {
            JsonArray overridden = new JsonArray();
            for (StringResult next = (StringResult)result.overriddenResult(); next != null; next = (StringResult)next.overriddenResult()) {
                overridden.add((JsonElement)MetaCheckEvent.serializeResult(next).toJson());
            }
            object.add("overridden", (JsonElement)overridden);
        }
        return object;
    }

    @Override
    public boolean eval(String variable) {
        return variable.equals("meta") || this.getCheckTarget().describe().equalsIgnoreCase(variable) || this.getKey().toLowerCase(Locale.ROOT).startsWith(variable.toLowerCase(Locale.ROOT)) || String.valueOf(((StringResult)this.getResult()).result()).equalsIgnoreCase(variable);
    }
}

