/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.socket;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.common.util.gson.JObject;

public enum SocketMessageType {
    HELLO("hello"),
    HELLO_REPLY("hello-reply"),
    CONNECTED("connected"),
    CHANGE_REQUEST("change-request"),
    CHANGE_RESPONSE("change-response"),
    PING("ping"),
    PONG("pong");

    public final String id;
    private static final Map<String, SocketMessageType> LOOKUP;

    private SocketMessageType(String id) {
        this.id = id;
    }

    public JObject builder() {
        return new JObject().add("type", this.id);
    }

    public static SocketMessageType getById(String id) {
        SocketMessageType type = LOOKUP.get(id);
        if (type == null) {
            throw new IllegalArgumentException(id);
        }
        return type;
    }

    static {
        LOOKUP = (Map)Arrays.stream(SocketMessageType.values()).collect(ImmutableCollectors.toMap(m -> m.id, Function.identity()));
    }
}

