/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.webeditor.store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.types.Meta;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.util.gson.GsonProvider;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;

public final class WebEditorKeystore {
    private static final String META_KEY = "lp-editor-key";
    private final Path consoleKeysPath;
    private final Set<String> trustedConsoleKeys;

    public WebEditorKeystore(Path consoleKeysPath) {
        this.consoleKeysPath = consoleKeysPath;
        this.trustedConsoleKeys = new CopyOnWriteArraySet<String>();
        try {
            this.load();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isTrusted(Sender sender, byte[] publicKey) {
        return this.isTrusted(sender, WebEditorKeystore.hash(publicKey));
    }

    public boolean isTrusted(Sender sender, String hash) {
        if (sender.isConsole()) {
            return this.isTrustedConsole(hash);
        }
        User user = (User)sender.getPlugin().getUserManager().getIfLoaded(sender.getUniqueId());
        return user != null && this.isTrusted(user, hash);
    }

    public void trust(Sender sender, byte[] publicKey) {
        this.trust(sender, WebEditorKeystore.hash(publicKey));
    }

    public void trust(Sender sender, String hash) {
        if (sender.isConsole()) {
            this.trustConsole(hash);
        } else {
            User user = (User)sender.getPlugin().getUserManager().getIfLoaded(sender.getUniqueId());
            if (user != null) {
                this.trust(user, hash);
            }
        }
    }

    private boolean isTrustedConsole(String hash) {
        return this.trustedConsoleKeys.contains(hash);
    }

    private void trustConsole(String hash) {
        this.trustedConsoleKeys.add(hash);
        try {
            this.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void load() throws Exception {
        if (Files.exists(this.consoleKeysPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(this.consoleKeysPath, StandardCharsets.UTF_8);){
                KeystoreFile file = (KeystoreFile)GsonProvider.normal().fromJson((Reader)reader, KeystoreFile.class);
                if (file != null && file.consoleKeys != null) {
                    this.trustedConsoleKeys.addAll(file.consoleKeys);
                }
            }
        }
    }

    private void save() throws Exception {
        try (BufferedWriter writer = Files.newBufferedWriter(this.consoleKeysPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            KeystoreFile file = new KeystoreFile();
            file.consoleKeys = new ArrayList<String>(this.trustedConsoleKeys);
            GsonProvider.prettyPrinting().toJson((Object)file, (Appendable)writer);
        }
    }

    private boolean isTrusted(User user, String hash) {
        String key = user.getCachedData().getMetaData(QueryOptionsImpl.DEFAULT_CONTEXTUAL).getMetaValue(META_KEY, CheckOrigin.INTERNAL).result();
        if (key == null || key.isEmpty()) {
            return false;
        }
        return hash.equals(key);
    }

    private void trust(User user, String hash) {
        user.removeIf(DataType.NORMAL, ImmutableContextSetImpl.EMPTY, NodeType.META.predicate(mn -> mn.getMetaKey().equals(META_KEY)), false);
        user.setNode(DataType.NORMAL, (Node)Meta.builder(META_KEY, hash).build(), false);
        user.getPlugin().getStorage().saveUser(user).join();
    }

    private static String hash(byte[] buf) {
        byte[] digest = WebEditorKeystore.createDigest().digest(buf);
        return Base64.getEncoder().encodeToString(digest);
    }

    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static class KeystoreFile {
        private String _comment = "This file stores a list of trusted editor public keys";
        private List<String> consoleKeys = null;

        private KeystoreFile() {
        }
    }
}

