/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import me.lucko.luckperms.common.plugin.bootstrap.LuckPermsBootstrap;
import me.lucko.luckperms.common.plugin.classpath.ClassPathAppender;
import me.lucko.luckperms.common.plugin.logging.PluginLogger;
import me.lucko.luckperms.common.plugin.logging.Slf4jPluginLogger;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import me.lucko.luckperms.velocity.VelocityClassPathAppender;
import me.lucko.luckperms.velocity.VelocitySchedulerAdapter;
import net.luckperms.api.platform.Platform;
import org.slf4j.Logger;

@Plugin(id="luckperms", name="LuckPerms", version="5.5.17", authors={"Luck"}, description="A permissions plugin", url="https://luckperms.net")
public class LPVelocityBootstrap
implements LuckPermsBootstrap {
    private final PluginLogger logger;
    private final SchedulerAdapter schedulerAdapter;
    private final ClassPathAppender classPathAppender;
    private final LPVelocityPlugin plugin;
    private Instant startTime;
    private final CountDownLatch loadLatch = new CountDownLatch(1);
    private final CountDownLatch enableLatch = new CountDownLatch(1);
    @Inject
    private ProxyServer proxy;
    @Inject
    @DataDirectory
    private Path configDirectory;

    @Inject
    public LPVelocityBootstrap(Logger logger) {
        this.logger = new Slf4jPluginLogger(logger);
        this.schedulerAdapter = new VelocitySchedulerAdapter(this);
        this.classPathAppender = new VelocityClassPathAppender(this);
        this.plugin = new LPVelocityPlugin(this);
    }

    @Override
    public PluginLogger getPluginLogger() {
        return this.logger;
    }

    @Override
    public SchedulerAdapter getScheduler() {
        return this.schedulerAdapter;
    }

    @Override
    public ClassPathAppender getClassPathAppender() {
        return this.classPathAppender;
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onEnable(ProxyInitializeEvent e) {
        this.startTime = Instant.now();
        try {
            this.plugin.load();
        }
        finally {
            this.loadLatch.countDown();
        }
        try {
            this.plugin.enable();
        }
        finally {
            this.enableLatch.countDown();
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onDisable(ProxyShutdownEvent e) {
        this.plugin.disable();
    }

    @Override
    public CountDownLatch getEnableLatch() {
        return this.enableLatch;
    }

    @Override
    public CountDownLatch getLoadLatch() {
        return this.loadLatch;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    @Override
    public String getVersion() {
        return "5.5.17";
    }

    @Override
    public Instant getStartupTime() {
        return this.startTime;
    }

    @Override
    public Platform.Type getType() {
        return Platform.Type.VELOCITY;
    }

    @Override
    public String getServerBrand() {
        return this.proxy.getVersion().getName();
    }

    @Override
    public String getServerVersion() {
        return this.proxy.getVersion().getVersion();
    }

    @Override
    public Path getDataDirectory() {
        return this.configDirectory.toAbsolutePath();
    }

    public Optional<Player> getPlayer(UUID uniqueId) {
        return this.proxy.getPlayer(uniqueId);
    }

    @Override
    public Optional<UUID> lookupUniqueId(String username) {
        return Optional.empty();
    }

    @Override
    public Optional<String> lookupUsername(UUID uniqueId) {
        return Optional.empty();
    }

    @Override
    public int getPlayerCount() {
        return this.proxy.getPlayerCount();
    }

    @Override
    public Collection<String> getPlayerList() {
        Collection players = this.proxy.getAllPlayers();
        ArrayList<String> list = new ArrayList<String>(players.size());
        for (Player player : players) {
            list.add(player.getUsername());
        }
        return list;
    }

    @Override
    public Collection<UUID> getOnlinePlayers() {
        Collection players = this.proxy.getAllPlayers();
        ArrayList<UUID> list = new ArrayList<UUID>(players.size());
        for (Player player : players) {
            list.add(player.getUniqueId());
        }
        return list;
    }

    @Override
    public boolean isPlayerOnline(UUID uniqueId) {
        Player player = this.proxy.getPlayer(uniqueId).orElse(null);
        return player != null && player.isActive();
    }
}

