/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity;

import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandInvocation;
import com.velocitypowered.api.command.RawCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.Arrays;
import java.util.List;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.utils.ArgumentTokenizer;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.velocity.LPVelocityPlugin;

public class VelocityCommandExecutor
extends CommandManager
implements RawCommand {
    private static final String PRIMARY_ALIAS = "luckpermsvelocity";
    private static final String[] ALIASES = new String[]{"lpv"};
    private static final String SLASH_PRIMARY_ALIAS = "/luckpermsvelocity";
    private static final String[] SLASH_ALIASES = (String[])Arrays.stream(ALIASES).map(s -> "/" + s).toArray(String[]::new);
    private final LPVelocityPlugin plugin;

    public VelocityCommandExecutor(LPVelocityPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public void register() {
        ProxyServer proxy = this.plugin.getBootstrap().getProxy();
        proxy.getCommandManager().register(PRIMARY_ALIAS, (Command)this, ALIASES);
        proxy.getCommandManager().register(SLASH_PRIMARY_ALIAS, (Command)new ForwardingCommand(this){

            public boolean hasPermission(RawCommand.Invocation invocation) {
                return invocation.source() instanceof ConsoleCommandSource;
            }
        }, SLASH_ALIASES);
    }

    public void execute(RawCommand.Invocation invocation) {
        Sender wrapped = this.plugin.getSenderFactory().wrap(invocation.source());
        List<String> arguments = ArgumentTokenizer.EXECUTE.tokenizeInput((String)invocation.arguments());
        this.executeCommand(wrapped, "lpv", arguments);
    }

    public List<String> suggest(RawCommand.Invocation invocation) {
        Sender wrapped = this.plugin.getSenderFactory().wrap(invocation.source());
        List<String> arguments = ArgumentTokenizer.TAB_COMPLETE.tokenizeInput((String)invocation.arguments());
        return this.tabCompleteCommand(wrapped, arguments);
    }

    private static class ForwardingCommand
    implements RawCommand {
        private final RawCommand delegate;

        private ForwardingCommand(RawCommand delegate) {
            this.delegate = delegate;
        }

        public void execute(RawCommand.Invocation invocation) {
            this.delegate.execute((CommandInvocation)invocation);
        }

        public List<String> suggest(RawCommand.Invocation invocation) {
            return this.delegate.suggest((CommandInvocation)invocation);
        }
    }
}

