/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity;

import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerAdapter;
import me.lucko.luckperms.common.plugin.scheduler.SchedulerTask;
import me.lucko.luckperms.common.util.Iterators;
import me.lucko.luckperms.velocity.LPVelocityBootstrap;

public class VelocitySchedulerAdapter
implements SchedulerAdapter {
    private final LPVelocityBootstrap bootstrap;
    private final Executor executor;
    private final Set<ScheduledTask> tasks = Collections.newSetFromMap(new WeakHashMap());

    public VelocitySchedulerAdapter(LPVelocityBootstrap bootstrap) {
        this.bootstrap = bootstrap;
        this.executor = r -> bootstrap.getProxy().getScheduler().buildTask((Object)bootstrap, r).schedule();
    }

    @Override
    public Executor async() {
        return this.executor;
    }

    @Override
    public Executor sync() {
        return this.executor;
    }

    @Override
    public SchedulerTask asyncLater(Runnable task, long delay, TimeUnit unit) {
        ScheduledTask t = this.bootstrap.getProxy().getScheduler().buildTask((Object)this.bootstrap, task).delay((long)((int)delay), unit).schedule();
        this.tasks.add(t);
        return () -> ((ScheduledTask)t).cancel();
    }

    @Override
    public SchedulerTask asyncRepeating(Runnable task, long interval, TimeUnit unit) {
        ScheduledTask t = this.bootstrap.getProxy().getScheduler().buildTask((Object)this.bootstrap, task).delay((long)((int)interval), unit).repeat((long)((int)interval), unit).schedule();
        this.tasks.add(t);
        return () -> ((ScheduledTask)t).cancel();
    }

    @Override
    public void shutdownScheduler() {
        Iterators.tryIterate(this.tasks, ScheduledTask::cancel);
    }

    @Override
    public void shutdownExecutor() {
    }
}

