/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Locale;
import java.util.UUID;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.sender.SenderFactory;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import me.lucko.luckperms.velocity.service.CompatibilityUtil;
import me.lucko.luckperms.velocity.util.AdventureCompat;
import net.luckperms.api.util.Tristate;

public class VelocitySenderFactory
extends SenderFactory<LPVelocityPlugin, CommandSource> {
    public VelocitySenderFactory(LPVelocityPlugin plugin) {
        super(plugin);
    }

    @Override
    protected String getName(CommandSource source) {
        if (source instanceof Player) {
            return ((Player)source).getUsername();
        }
        return "Console";
    }

    @Override
    protected UUID getUniqueId(CommandSource source) {
        if (source instanceof Player) {
            return ((Player)source).getUniqueId();
        }
        return Sender.CONSOLE_UUID;
    }

    @Override
    protected void sendMessage(CommandSource source, Component message) {
        Locale locale = null;
        if (source instanceof Player) {
            locale = ((Player)source).getPlayerSettings().getLocale();
        }
        Component rendered = TranslationManager.render(message, locale);
        AdventureCompat.sendMessage(source, rendered);
    }

    @Override
    protected Tristate getPermissionValue(CommandSource source, String node) {
        return CompatibilityUtil.convertTristate(source.getPermissionValue(node));
    }

    @Override
    protected boolean hasPermission(CommandSource source, String node) {
        return source.hasPermission(node);
    }

    @Override
    protected void performCommand(CommandSource source, String command) {
        ((LPVelocityPlugin)this.getPlugin()).getBootstrap().getProxy().getCommandManager().executeAsync(source, command).join();
    }

    @Override
    protected boolean isConsole(CommandSource sender) {
        return sender instanceof ConsoleCommandSource;
    }
}

