/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.calculator;

import java.util.ArrayList;
import me.lucko.luckperms.common.cacheddata.CacheMetadata;
import me.lucko.luckperms.common.calculator.CalculatorFactory;
import me.lucko.luckperms.common.calculator.PermissionCalculator;
import me.lucko.luckperms.common.calculator.processor.DirectProcessor;
import me.lucko.luckperms.common.calculator.processor.PermissionProcessor;
import me.lucko.luckperms.common.calculator.processor.RegexProcessor;
import me.lucko.luckperms.common.calculator.processor.SpongeWildcardProcessor;
import me.lucko.luckperms.common.calculator.processor.WildcardProcessor;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import net.luckperms.api.query.QueryOptions;

public class VelocityCalculatorFactory
implements CalculatorFactory {
    private final LPVelocityPlugin plugin;

    public VelocityCalculatorFactory(LPVelocityPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public PermissionCalculator build(QueryOptions queryOptions, CacheMetadata metadata) {
        ArrayList<PermissionProcessor> processors = new ArrayList<PermissionProcessor>(4);
        processors.add(new DirectProcessor());
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_REGEX).booleanValue()) {
            processors.add(new RegexProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS).booleanValue()) {
            processors.add(new WildcardProcessor());
        }
        if (this.plugin.getConfiguration().get(ConfigKeys.APPLYING_WILDCARDS_SPONGE).booleanValue()) {
            processors.add(new SpongeWildcardProcessor());
        }
        return new PermissionCalculator(this.plugin, metadata, processors);
    }
}

