/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.context;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.context.ImmutableContextSetImpl;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;

public class VelocityPlayerCalculator
implements ContextCalculator<Player> {
    private final LPVelocityPlugin plugin;

    public VelocityPlayerCalculator(LPVelocityPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void calculate(@NonNull Player subject, @NonNull ContextConsumer consumer) {
        ServerConnection server = subject.getCurrentServer().orElse(null);
        if (server == null) {
            return;
        }
        this.plugin.getConfiguration().get(ConfigKeys.WORLD_REWRITES).rewriteAndSubmit(server.getServerInfo().getName(), consumer);
    }

    @Override
    public @NonNull @NotNull ContextSet estimatePotentialContexts() {
        ImmutableContextSetImpl.BuilderImpl builder = new ImmutableContextSetImpl.BuilderImpl();
        for (RegisteredServer server : this.plugin.getBootstrap().getProxy().getAllServers()) {
            builder.add("world", server.getServerInfo().getName());
        }
        return builder.build();
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onServerConnect(ServerConnectedEvent e) {
        this.plugin.getContextManager().signalContextUpdate(e.getPlayer());
    }
}

