/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.listeners;

import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.permission.PermissionsSetupEvent;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.proxy.Player;
import me.lucko.luckperms.common.cacheddata.result.TristateResult;
import me.lucko.luckperms.common.query.QueryOptionsImpl;
import me.lucko.luckperms.common.verbose.VerboseCheckTarget;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import me.lucko.luckperms.velocity.service.CompatibilityUtil;
import net.luckperms.api.util.Tristate;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MonitoringPermissionCheckListener {
    private final LPVelocityPlugin plugin;

    public MonitoringPermissionCheckListener(LPVelocityPlugin plugin) {
        this.plugin = plugin;
    }

    @Subscribe(order=PostOrder.LAST)
    public void onOtherPermissionSetup(PermissionsSetupEvent e) {
        if (e.getSubject() instanceof Player) {
            return;
        }
        e.setProvider((PermissionProvider)new MonitoredPermissionProvider(e.getProvider()));
    }

    private String determineName(PermissionSubject subject) {
        if (subject == this.plugin.getBootstrap().getProxy().getConsoleCommandSource()) {
            return "console";
        }
        return subject.getClass().getSimpleName();
    }

    private final class MonitoredPermissionProvider
    implements PermissionProvider {
        private final PermissionProvider delegate;

        MonitoredPermissionProvider(PermissionProvider delegate) {
            this.delegate = delegate;
        }

        public @NonNull PermissionFunction createFunction(@NonNull PermissionSubject subject) {
            PermissionFunction function = this.delegate.createFunction(subject);
            return new MonitoredPermissionFunction(subject, function);
        }
    }

    private final class MonitoredPermissionFunction
    implements PermissionFunction {
        private final VerboseCheckTarget verboseCheckTarget;
        private final PermissionFunction delegate;

        MonitoredPermissionFunction(PermissionSubject subject, PermissionFunction delegate) {
            this.delegate = delegate;
            this.verboseCheckTarget = VerboseCheckTarget.internal(MonitoringPermissionCheckListener.this.determineName(subject));
        }

        public @NonNull com.velocitypowered.api.permission.Tristate getPermissionValue(@NonNull String permission) {
            com.velocitypowered.api.permission.Tristate setting = this.delegate.getPermissionValue(permission);
            Tristate result = CompatibilityUtil.convertTristate(setting);
            MonitoringPermissionCheckListener.this.plugin.getVerboseHandler().offerPermissionCheckEvent(CheckOrigin.PLATFORM_API_HAS_PERMISSION_SET, this.verboseCheckTarget, QueryOptionsImpl.DEFAULT_CONTEXTUAL, permission, TristateResult.forMonitoredResult(result));
            MonitoringPermissionCheckListener.this.plugin.getPermissionRegistry().offer(permission);
            return setting;
        }
    }
}

