/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.listeners;

import com.google.common.base.Function;
import com.velocitypowered.api.event.Continuation;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.LoginEvent;
import com.velocitypowered.api.event.permission.PermissionsSetupEvent;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.proxy.Player;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.Message;
import me.lucko.luckperms.common.locale.TranslationManager;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.util.AbstractConnectionListener;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import me.lucko.luckperms.velocity.context.VelocityContextManager;
import me.lucko.luckperms.velocity.service.PlayerPermissionProvider;
import me.lucko.luckperms.velocity.util.AdventureCompat;
import net.luckperms.api.query.QueryOptions;

public class VelocityConnectionListener
extends AbstractConnectionListener {
    private final LPVelocityPlugin plugin;
    private final Set<UUID> deniedLogin = Collections.synchronizedSet(new HashSet());

    public VelocityConnectionListener(LPVelocityPlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Subscribe
    public void onPlayerPermissionsSetup(PermissionsSetupEvent e, Continuation continuation) {
        if (!(e.getSubject() instanceof Player)) {
            continuation.resume();
            return;
        }
        Player p = (Player)e.getSubject();
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing pre-login for " + String.valueOf(p.getUniqueId()) + " - " + p.getUsername());
        }
        this.plugin.getBootstrap().getScheduler().executeAsync(() -> {
            try {
                User user = this.loadUser(p.getUniqueId(), p.getUsername());
                this.recordConnection(p.getUniqueId());
                VelocityContextManager contextManager = this.plugin.getContextManager();
                e.setProvider((PermissionProvider)new PlayerPermissionProvider(p, user, (Function<Player, QueryOptions>)((Function)contextManager::getQueryOptions)));
                this.plugin.getEventDispatcher().dispatchPlayerLoginProcess(p.getUniqueId(), p.getUsername(), user);
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Exception occurred whilst loading data for " + String.valueOf(p.getUniqueId()) + " - " + p.getUsername(), ex);
                if (this.plugin.getConfiguration().get(ConfigKeys.CANCEL_FAILED_LOGINS).booleanValue()) {
                    this.deniedLogin.add(p.getUniqueId());
                }
                this.plugin.getEventDispatcher().dispatchPlayerLoginProcess(p.getUniqueId(), p.getUsername(), null);
            }
            finally {
                continuation.resume();
            }
        });
    }

    @Subscribe(order=PostOrder.FIRST)
    public void onPlayerLogin(LoginEvent e) {
        Player player = e.getPlayer();
        if (this.deniedLogin.remove(player.getUniqueId())) {
            e.setResult(AdventureCompat.deniedResult(TranslationManager.render(Message.LOADING_DATABASE_ERROR.build(), player.getPlayerSettings().getLocale())));
        }
    }

    @Subscribe
    public void onPlayerPostLogin(LoginEvent e) {
        Player player = e.getPlayer();
        User user = (User)this.plugin.getUserManager().getIfLoaded(e.getPlayer().getUniqueId());
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing post-login for " + String.valueOf(player.getUniqueId()) + " - " + player.getUsername());
        }
        if (!e.getResult().isAllowed()) {
            return;
        }
        if (user == null) {
            if (!this.getUniqueConnections().contains(player.getUniqueId())) {
                this.plugin.getLogger().warn("User " + String.valueOf(player.getUniqueId()) + " - " + player.getUsername() + " doesn't have data pre-loaded, they have never been processed during pre-login in this session.");
            } else {
                this.plugin.getLogger().warn("User " + String.valueOf(player.getUniqueId()) + " - " + player.getUsername() + " doesn't currently have data pre-loaded, but they have been processed before in this session.");
            }
            if (this.plugin.getConfiguration().get(ConfigKeys.CANCEL_FAILED_LOGINS).booleanValue()) {
                e.setResult(AdventureCompat.deniedResult(TranslationManager.render(Message.LOADING_STATE_ERROR.build(), player.getPlayerSettings().getLocale())));
            } else {
                this.plugin.getBootstrap().getScheduler().asyncLater(() -> {
                    if (!player.isActive()) {
                        return;
                    }
                    Message.LOADING_STATE_ERROR.send(this.plugin.getSenderFactory().wrap(player));
                }, 1L, TimeUnit.SECONDS);
            }
        }
    }

    @Subscribe(order=PostOrder.LAST)
    public void onPlayerQuit(DisconnectEvent e) {
        this.handleDisconnect(e.getPlayer().getUniqueId());
    }
}

