/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.messaging;

import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import me.lucko.luckperms.common.messaging.pluginmsg.AbstractPluginMessageMessenger;
import me.lucko.luckperms.velocity.LPVelocityPlugin;
import net.luckperms.api.messenger.IncomingMessageConsumer;

public class PluginMessageMessenger
extends AbstractPluginMessageMessenger {
    private static final ChannelIdentifier CHANNEL = MinecraftChannelIdentifier.from((String)"luckperms:update");
    private final LPVelocityPlugin plugin;

    public PluginMessageMessenger(LPVelocityPlugin plugin, IncomingMessageConsumer consumer) {
        super(consumer);
        this.plugin = plugin;
    }

    public void init() {
        ProxyServer proxy = this.plugin.getBootstrap().getProxy();
        proxy.getChannelRegistrar().register(new ChannelIdentifier[]{CHANNEL});
        proxy.getEventManager().register((Object)this.plugin.getBootstrap(), (Object)this);
    }

    @Override
    public void close() {
        ProxyServer proxy = this.plugin.getBootstrap().getProxy();
        proxy.getChannelRegistrar().unregister(new ChannelIdentifier[]{CHANNEL});
        proxy.getEventManager().unregisterListener((Object)this.plugin.getBootstrap(), (Object)this);
    }

    @Override
    protected void sendOutgoingMessage(byte[] buf) {
        for (RegisteredServer server : this.plugin.getBootstrap().getProxy().getAllServers()) {
            server.sendPluginMessage(CHANNEL, buf);
        }
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent e) {
        if (!e.getIdentifier().getId().equals(CHANNEL.getId())) {
            return;
        }
        e.setResult(PluginMessageEvent.ForwardResult.handled());
        if (e.getSource() instanceof Player) {
            return;
        }
        byte[] buf = e.getData();
        if (this.handleIncomingMessage(buf)) {
            this.plugin.getBootstrap().getScheduler().executeAsync(() -> this.sendOutgoingMessage(buf));
        }
    }
}

