/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.permission.PermissionSubject;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.Player;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.verbose.event.CheckOrigin;
import me.lucko.luckperms.velocity.service.CompatibilityUtil;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PlayerPermissionProvider
implements PermissionProvider,
PermissionFunction {
    private final Player player;
    private final User user;
    private final Function<Player, QueryOptions> queryOptionsSupplier;

    public PlayerPermissionProvider(Player player, User user, Function<Player, QueryOptions> queryOptionsSupplier) {
        this.player = player;
        this.user = user;
        this.queryOptionsSupplier = queryOptionsSupplier;
    }

    public @NonNull PermissionFunction createFunction(@NonNull PermissionSubject subject) {
        Preconditions.checkState((subject == this.player ? 1 : 0) != 0, (Object)"createFunction called with different argument");
        return this;
    }

    public @NonNull Tristate getPermissionValue(@NonNull String permission) {
        QueryOptions queryOptions = (QueryOptions)this.queryOptionsSupplier.apply((Object)this.player);
        return CompatibilityUtil.convertTristate(this.user.getCachedData().getPermissionData(queryOptions).checkPermission(permission, CheckOrigin.PLATFORM_API_HAS_PERMISSION).result());
    }
}

