/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.velocity.util;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.ResultedEvent;
import java.lang.reflect.Method;
import me.lucko.luckperms.lib.adventure.text.Component;
import me.lucko.luckperms.lib.adventure.text.serializer.gson.GsonComponentSerializer;

public final class AdventureCompat {
    private static final Method PLATFORM_SERIALIZER_DESERIALIZE;
    private static final Method PLATFORM_SEND_MESSAGE;
    private static final Method PLATFORM_COMPONENT_RESULT_DENIED;
    private static final Object PLATFORM_SERIALIZER_INSTANCE;

    private AdventureCompat() {
    }

    public static Object toPlatformComponent(Component component) {
        String json = (String)GsonComponentSerializer.gson().serialize(component);
        try {
            return PLATFORM_SERIALIZER_DESERIALIZE.invoke(PLATFORM_SERIALIZER_INSTANCE, json);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendMessage(CommandSource audience, Component message) {
        try {
            PLATFORM_SEND_MESSAGE.invoke((Object)audience, AdventureCompat.toPlatformComponent(message));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ResultedEvent.ComponentResult deniedResult(Component message) {
        try {
            return (ResultedEvent.ComponentResult)PLATFORM_COMPONENT_RESULT_DENIED.invoke(null, AdventureCompat.toPlatformComponent(message));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String adventurePkg = "net.kyo".concat("ri.adventure.");
        try {
            Class<?> audienceClass = Class.forName(adventurePkg + "audience.Audience");
            Class<?> componentClass = Class.forName(adventurePkg + "text.Component");
            Class<?> serializerClass = Class.forName(adventurePkg + "text.serializer.gson.GsonComponentSerializer");
            PLATFORM_SERIALIZER_DESERIALIZE = serializerClass.getMethod("deserialize", Object.class);
            PLATFORM_SEND_MESSAGE = audienceClass.getMethod("sendMessage", componentClass);
            PLATFORM_COMPONENT_RESULT_DENIED = ResultedEvent.ComponentResult.class.getMethod("denied", componentClass);
            PLATFORM_SERIALIZER_INSTANCE = serializerClass.getMethod("gson", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

