/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.context;

import java.util.Objects;
import java.util.function.Supplier;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface StaticContextCalculator
extends ContextCalculator<Object> {
    public static StaticContextCalculator forSingleContext(String key, Supplier<String> valueFunction) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(valueFunction, "valueFunction");
        return consumer -> {
            String value = (String)valueFunction.get();
            if (value != null) {
                consumer.accept(key, value);
            }
        };
    }

    public void calculate(@NonNull ContextConsumer var1);

    @Override
    default public void calculate(@NonNull Object target, @NonNull ContextConsumer consumer) {
        this.calculate(consumer);
    }
}

