/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.metastacking;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface DuplicateRemovalFunction {
    public static final DuplicateRemovalFunction RETAIN_ALL = new DuplicateRemovalFunction(){

        @Override
        public <T> void processDuplicates(@NonNull List<T> list) {
        }

        public String toString() {
            return "DuplicateRemovalFunction#RETAIN_ALL";
        }
    };
    public static final DuplicateRemovalFunction FIRST_ONLY = new DuplicateRemovalFunction(){

        @Override
        public <T> void processDuplicates(@NonNull List<T> list) {
            HashSet<T> seen = new HashSet<T>(list.size());
            ListIterator<T> it = list.listIterator();
            while (it.hasNext()) {
                T next = it.next();
                if (seen.add(next)) continue;
                it.remove();
            }
        }

        public String toString() {
            return "DuplicateRemovalFunction#FIRST_ONLY";
        }
    };
    public static final DuplicateRemovalFunction LAST_ONLY = new DuplicateRemovalFunction(){

        @Override
        public <T> void processDuplicates(@NonNull List<T> list) {
            HashSet<T> seen = new HashSet<T>(list.size());
            ListIterator<T> it = list.listIterator(list.size());
            while (it.hasPrevious()) {
                T next = it.previous();
                if (seen.add(next)) continue;
                it.remove();
            }
        }

        public String toString() {
            return "DuplicateRemovalFunction#LAST_ONLY";
        }
    };

    public <T> void processDuplicates(@NonNull List<T> var1);
}

