/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.model.user;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.luckperms.api.model.PlayerSaveResult;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.HeldNode;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.matcher.NodeMatcher;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface UserManager {
    public @NonNull CompletableFuture<User> loadUser(@NonNull UUID var1, @Nullable String var2);

    default public @NonNull CompletableFuture<User> loadUser(@NonNull UUID uniqueId) {
        return this.loadUser(uniqueId, null);
    }

    public @NonNull CompletableFuture<UUID> lookupUniqueId(@NonNull String var1);

    public @NonNull CompletableFuture<String> lookupUsername(@NonNull UUID var1);

    public @NonNull CompletableFuture<Void> saveUser(@NonNull User var1);

    default public @NonNull CompletableFuture<Void> modifyUser(@NonNull UUID uniqueId, @NonNull Consumer<? super User> action) {
        return ((CompletableFuture)this.loadUser(uniqueId).thenApplyAsync(user -> {
            action.accept((User)user);
            return user;
        })).thenCompose(this::saveUser);
    }

    public @NonNull CompletableFuture<PlayerSaveResult> savePlayerData(@NonNull UUID var1, @NonNull String var2);

    public @NonNull CompletableFuture<Void> deletePlayerData(@NonNull UUID var1);

    public @NonNull CompletableFuture<@Unmodifiable Set<UUID>> getUniqueUsers();

    public <T extends Node> @NonNull CompletableFuture<@Unmodifiable Map<UUID, Collection<T>>> searchAll(@NonNull NodeMatcher<? extends T> var1);

    @Deprecated
    public @NonNull CompletableFuture<@Unmodifiable List<HeldNode<UUID>>> getWithPermission(@NonNull String var1);

    public @Nullable User getUser(@NonNull UUID var1);

    public @Nullable User getUser(@NonNull String var1);

    public @NonNull @Unmodifiable Set<User> getLoadedUsers();

    public boolean isLoaded(@NonNull UUID var1);

    public void cleanupUser(@NonNull User var1);
}

