/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.event;

import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.PortalIgniter;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.linking.PortalLinkingStorage;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber(modid="cpapireforged")
public class NeoEventSubscriber {
    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        for (ResourceKey registryKey : event.getServer().levelKeys()) {
            CustomPortalsMod.dimensions.put(registryKey.location(), (ResourceKey<Level>)registryKey);
        }
        CustomPortalsMod.portalLinkingStorage = (PortalLinkingStorage)event.getServer().overworld().getDataStorage().computeIfAbsent(PortalLinkingStorage.TYPE);
    }

    @SubscribeEvent
    public static void rightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
        BlockHitResult blockHit;
        HitResult hit;
        Item item;
        Player player = event.getEntity();
        Level level = event.getLevel();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide() && PortalIgnitionSource.isRegisteredIgnitionSourceWith(item = stack.getItem()) && (hit = player.pick(6.0, 1.0f, false)).getType() == HitResult.Type.BLOCK && PortalIgniter.attemptPortalLight(level, (blockHit = (BlockHitResult)hit).getBlockPos().relative(blockHit.getDirection()), PortalIgnitionSource.fromItem(item).withPlayer(player))) {
            event.setCanceled(true);
        }
    }
}

