/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomPortalHelper {
    public static boolean isInstanceOfCustomPortal(Level world, BlockPos pos) {
        return CustomPortalHelper.isInstanceOfCustomPortal(world.getBlockState(pos));
    }

    public static boolean isInstanceOfCustomPortal(BlockState state) {
        return state.getBlock() instanceof CustomPortalBlock;
    }

    public static boolean isInstanceOfPortalFrame(Level world, BlockPos pos) {
        if (world.isInWorldBounds(pos)) {
            return CustomPortalsMod.isRegisteredFrameBlock(world.getBlockState(pos));
        }
        return false;
    }

    public static Block getPortalBase(Level world, BlockPos pos) {
        if (CustomPortalHelper.isInstanceOfCustomPortal(world, pos)) {
            return ((CustomPortalBlock)world.getBlockState(pos).getBlock()).getPortalBase(world, pos);
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos)) {
            return world.getBlockState(pos).getBlock();
        }
        return Blocks.AIR;
    }

    public static Block getPortalBaseDefault(Level world, BlockPos pos) {
        if (CustomPortalHelper.isInstanceOfCustomPortal(world, pos)) {
            Direction.Axis axis = CustomPortalHelper.getAxisFrom(world.getBlockState(pos));
            if (axis != Direction.Axis.Y) {
                if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.below())) {
                    return world.getBlockState(pos.below()).getBlock();
                }
                if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.above())) {
                    return world.getBlockState(pos.above()).getBlock();
                }
            } else {
                axis = Direction.Axis.Z;
            }
            if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.relative(axis, -1))) {
                return world.getBlockState(pos.relative(axis, -1)).getBlock();
            }
            if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.relative(axis, 1))) {
                return world.getBlockState(pos.relative(axis, 1)).getBlock();
            }
            return CustomPortalHelper.getPortalBaseDefault(world, pos.relative(axis, -1));
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos)) {
            return world.getBlockState(pos).getBlock();
        }
        return Blocks.AIR;
    }

    public static BlockPos getClosestFrameBlock(Level world, BlockPos pos) {
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.below())) {
            return pos.below();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.east())) {
            return pos.east();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.west())) {
            return pos.west();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.north())) {
            return pos.north();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.south())) {
            return pos.south();
        }
        if (CustomPortalHelper.isInstanceOfPortalFrame(world, pos.above())) {
            return pos.above();
        }
        return pos;
    }

    public static Direction.Axis getAxisFrom(BlockState state) {
        if (state.getBlock() instanceof CustomPortalBlock) {
            return (Direction.Axis)state.getValue(CustomPortalBlock.AXIS);
        }
        if (state.getBlock() instanceof NetherPortalBlock) {
            return (Direction.Axis)state.getValue((Property)NetherPortalBlock.AXIS);
        }
        if (state.getBlock() instanceof EndPortalBlock) {
            return Direction.Axis.Y;
        }
        return Direction.Axis.X;
    }

    public static BlockState blockWithAxis(BlockState state, Direction.Axis axis) {
        if (state.getBlock() instanceof CustomPortalBlock) {
            return (BlockState)state.setValue(CustomPortalBlock.AXIS, (Comparable)axis);
        }
        return state;
    }
}

