/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.network.PlayerSoundPayload;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.portal.frame.VanillaPortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class PortalLink {
    @Nullable
    private Block frameBlock;
    public PortalIgnitionSource ignitionSource = PortalIgnitionSource.FIRE;
    public CustomPortalBlock portalBlock = CustomPortalsMod.CUSTOM_PORTAL_BLOCK.get();
    public ResourceLocation targetDimensionLocation = ResourceLocation.withDefaultNamespace((String)"nether");
    public ResourceLocation returnDimensionLocation = ResourceLocation.withDefaultNamespace((String)"overworld");
    public boolean onlyIgnitableInReturnDimension = false;
    public int color;
    public int strictWidth;
    public int strictHeight;
    public int portalSearchYBottom;
    public int portalSearchYTop = Integer.MIN_VALUE;
    public int returnPortalSearchYBottom;
    public int returnPortalSearchYTop = Integer.MIN_VALUE;
    public PortalFrameTester portalFrameTester = new VanillaPortalFrameTester();
    private Consumer<Entity> postTeleportEvent = entity -> {};
    private Function<Entity, Boolean> preTeleportEvent = entity -> true;
    private BiFunction<BlockPos, PortalIgnitionSource, Boolean> prePortalIgniteEvent = (portalPos, source) -> true;
    private BiConsumer<BlockPos, PortalIgnitionSource> postPortalIgniteEvent = (portalPos, source) -> {};
    @Nullable
    private ResourceLocation travelSoundLocation = BuiltInRegistries.SOUND_EVENT.getKeyOrNull((Object)SoundEvents.PORTAL_TRAVEL);
    private Function<Entity, Float> travelSoundVolume = entity -> Float.valueOf(entity.getRandom().nextFloat() * 0.4f + 0.8f);
    private Function<Entity, Float> travelSoundPitch = entity -> Float.valueOf(0.25f);
    @Nullable
    public ResourceLocation triggerSoundLocation = BuiltInRegistries.SOUND_EVENT.getKeyOrNull((Object)SoundEvents.PORTAL_TRIGGER);
    public Function<Entity, Float> triggerSoundVolume = entity -> Float.valueOf(entity.getRandom().nextFloat() * 0.4f + 0.8f);
    public Function<Entity, Float> triggerSoundPitch = entity -> Float.valueOf(0.25f);
    @Nullable
    public ResourceLocation ambientSoundLocation = BuiltInRegistries.SOUND_EVENT.getKeyOrNull((Object)SoundEvents.PORTAL_AMBIENT);
    public Function<Level, Float> ambientSoundVolume = level -> Float.valueOf(0.5f);
    public Function<Level, Float> ambientSoundPitch = level -> Float.valueOf(level.random.nextFloat() * 0.4f + 0.8f);
    public BiFunction<Level, BlockPos, ParticleOptions> portalParticle = (level, pos) -> new BlockParticleOption(ParticleTypes.BLOCK, CustomPortalHelper.getPortalBaseDefault(level, pos).defaultBlockState());

    public Block getFrameBlock() {
        if (this.frameBlock == null) {
            throw new IllegalStateException("Frame block is not set!");
        }
        return this.frameBlock;
    }

    public void setFrameBlock(Block frameBlock) {
        this.frameBlock = frameBlock;
    }

    public boolean doesIgnitionMatch(PortalIgnitionSource attemptedSource) {
        return this.ignitionSource.sourceType == attemptedSource.sourceType && this.ignitionSource.ignitionSourceID.equals((Object)attemptedSource.ignitionSourceID);
    }

    public boolean canLightInDim(ResourceLocation dim) {
        if (!this.onlyIgnitableInReturnDimension) {
            return true;
        }
        return dim.equals((Object)this.returnDimensionLocation) || dim.equals((Object)this.targetDimensionLocation);
    }

    public Function<Entity, Boolean> getPreTeleportEvent() {
        return this.preTeleportEvent;
    }

    public void setPreTeleportEvent(Function<Entity, Boolean> event) {
        this.preTeleportEvent = event;
    }

    public void setPostTeleportEvent(Consumer<Entity> event) {
        this.postTeleportEvent = event;
    }

    public void executePostTeleportEvent(Entity entity) {
        this.postTeleportEvent.accept(entity);
    }

    public BiFunction<BlockPos, PortalIgnitionSource, Boolean> getPrePortalIgniteEvent() {
        return this.prePortalIgniteEvent;
    }

    public void setPrePortalIgniteEvent(BiFunction<BlockPos, PortalIgnitionSource, Boolean> event) {
        this.prePortalIgniteEvent = event;
    }

    public BiConsumer<BlockPos, PortalIgnitionSource> getPostPortalIgniteEvent() {
        return this.postPortalIgniteEvent;
    }

    public void setPostPortalIgniteEvent(BiConsumer<BlockPos, PortalIgnitionSource> event) {
        this.postPortalIgniteEvent = event;
    }

    public void setTravelSound(ResourceLocation travelSoundLocation, Function<Entity, Float> travelSoundVolume, Function<Entity, Float> travelSoundPitch) {
        this.travelSoundLocation = travelSoundLocation;
        this.travelSoundVolume = travelSoundVolume;
        this.travelSoundPitch = travelSoundPitch;
    }

    public void playTravelSound(Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (this.travelSoundLocation != null) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PlayerSoundPayload(this.travelSoundLocation, this.travelSoundVolume.apply(entity).floatValue(), this.travelSoundPitch.apply(entity).floatValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void setTriggerSound(ResourceLocation triggerSoundLocation, Function<Entity, Float> triggerSoundVolume, Function<Entity, Float> triggerSoundPitch) {
        this.triggerSoundLocation = triggerSoundLocation;
        this.triggerSoundVolume = triggerSoundVolume;
        this.triggerSoundPitch = triggerSoundPitch;
    }

    public void setAmbientSound(ResourceLocation ambientSoundLocation, Function<Level, Float> ambientSoundVolume, Function<Level, Float> ambientSoundPitch) {
        this.ambientSoundLocation = ambientSoundLocation;
        this.ambientSoundVolume = ambientSoundVolume;
        this.ambientSoundPitch = ambientSoundPitch;
    }

    public PortalFrameTester getFrameTester() {
        return this.portalFrameTester;
    }
}

