/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi;

import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.CustomTeleporter;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CustomPortalBlock
extends Block
implements Portal {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    protected static final VoxelShape X_SHAPE = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_SHAPE = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Y_SHAPE = Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public CustomPortalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            case Direction.Axis.Z -> Z_SHAPE;
            case Direction.Axis.Y -> Y_SHAPE;
            default -> X_SHAPE;
        };
    }

    protected ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return ItemStack.EMPTY;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        PortalFrameTester portalFrameTester;
        Block portalBase = this.getPortalBase((Level)level, pos);
        PortalLink link = CustomPortalsMod.getPortalLinkFromBase(portalBase);
        if (link != null && (portalFrameTester = link.getFrameTester().init((LevelAccessor)level, pos, CustomPortalHelper.getAxisFrom(state), portalBase)).isAlreadyLitPortalFrame()) {
            return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
        }
        return Blocks.AIR.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        SoundEvent event;
        Block portalBase = this.getPortalBase(level, pos);
        PortalLink link = CustomPortalsMod.getPortalLinkFromBase(portalBase);
        if (link == null) {
            return;
        }
        if (random.nextInt(100) == 0 && (event = (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(link.ambientSoundLocation)) != null) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, event, SoundSource.BLOCKS, link.ambientSoundVolume.apply(level).floatValue(), link.ambientSoundPitch.apply(level).floatValue(), false);
        }
        for (int i = 0; i < 4; ++i) {
            double dX = (double)pos.getX() + random.nextDouble();
            double dY = (double)pos.getY() + random.nextDouble();
            double dZ = (double)pos.getZ() + random.nextDouble();
            double sX = ((double)random.nextFloat() - 0.5) * 0.5;
            double sY = ((double)random.nextFloat() - 0.5) * 0.5;
            double sZ = ((double)random.nextFloat() - 0.5) * 0.5;
            int mod = random.nextInt(2) * 2 - 1;
            if (!level.getBlockState(pos.west()).is((Block)this) && !level.getBlockState(pos.east()).is((Block)this)) {
                dX = (float)pos.getX() + 0.5f + 0.25f * (float)mod;
                sX = random.nextFloat() * 2.0f * (float)mod;
            } else {
                dZ = (float)pos.getZ() + 0.5f + 0.25f * (float)mod;
                sZ = random.nextFloat() * 2.0f * (float)mod;
            }
            level.addParticle(link.portalParticle.apply(level, pos), dX, dY, dZ, sX, sY, sZ);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier applier, boolean intersects) {
        if (entity.canUsePortal(false)) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    public int getPortalTransitionTime(ServerLevel level, Entity entity) {
        if (entity instanceof Player) {
            Player playerEntity = (Player)entity;
            return Math.max(1, level.getGameRules().getInt(playerEntity.getAbilities().invulnerable ? GameRules.RULE_PLAYERS_NETHER_PORTAL_CREATIVE_DELAY : GameRules.RULE_PLAYERS_NETHER_PORTAL_DEFAULT_DELAY));
        }
        return 0;
    }

    public Block getPortalBase(Level level, BlockPos pos) {
        return CustomPortalHelper.getPortalBaseDefault(level, pos);
    }

    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        return CustomTeleporter.attemptTeleport((Level)level, entity, this.getPortalBase((Level)level, pos), pos);
    }

    public Portal.Transition getLocalTransition() {
        return Portal.Transition.CONFUSION;
    }
}

