/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.api;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.FlatPortalFrameTester;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class CustomPortalBuilder {
    private final PortalLink portalLink = new PortalLink();

    public void build() {
        CustomPortalsMod.addPortal(this.portalLink.getFrameBlock(), this.portalLink);
    }

    public CustomPortalBuilder frame(ResourceLocation blockLocation) {
        this.portalLink.setFrameBlock((Block)BuiltInRegistries.BLOCK.getValue(blockLocation));
        return this;
    }

    public CustomPortalBuilder frame(Block block) {
        this.portalLink.setFrameBlock(block);
        return this;
    }

    public CustomPortalBuilder destination(ResourceLocation dimensionLocation) {
        this.portalLink.targetDimensionLocation = dimensionLocation;
        return this;
    }

    public CustomPortalBuilder tintColor(int color) {
        this.portalLink.color = color;
        return this;
    }

    public CustomPortalBuilder tintColor(int r, int g, int b) {
        this.portalLink.color = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        return this;
    }

    public CustomPortalBuilder lightWithItem(Item item) {
        this.portalLink.ignitionSource = PortalIgnitionSource.fromItem(item);
        return this;
    }

    public CustomPortalBuilder lightWithFluid(Fluid fluid) {
        this.portalLink.ignitionSource = PortalIgnitionSource.fromFluid(fluid);
        return this;
    }

    public CustomPortalBuilder customIgnitionSource(ResourceLocation customSourceLocation) {
        this.portalLink.ignitionSource = PortalIgnitionSource.fromCustomSource(customSourceLocation);
        return this;
    }

    public CustomPortalBuilder customIgnitionSource(PortalIgnitionSource ignitionSource) {
        this.portalLink.ignitionSource = ignitionSource;
        return this;
    }

    public CustomPortalBuilder withStrictDimensions(int width, int height) {
        this.portalLink.strictWidth = width;
        this.portalLink.strictHeight = height;
        return this;
    }

    public CustomPortalBuilder customPortalBlock(CustomPortalBlock portalBlock) {
        this.portalLink.portalBlock = portalBlock;
        return this;
    }

    public CustomPortalBuilder returnDimension(ResourceLocation returnDimensionLocation, boolean onlyIgnitableInReturnDimension) {
        this.portalLink.returnDimensionLocation = returnDimensionLocation;
        this.portalLink.onlyIgnitableInReturnDimension = onlyIgnitableInReturnDimension;
        return this;
    }

    public CustomPortalBuilder onlyLightInOverworld() {
        this.portalLink.onlyIgnitableInReturnDimension = true;
        return this;
    }

    public CustomPortalBuilder flatPortal() {
        this.portalLink.portalFrameTester = new FlatPortalFrameTester();
        return this;
    }

    public CustomPortalBuilder customFrameTester(PortalFrameTester frameTester) {
        this.portalLink.portalFrameTester = frameTester;
        return this;
    }

    public CustomPortalBuilder preTeleportEvent(Function<Entity, Boolean> event) {
        this.portalLink.setPreTeleportEvent(event);
        return this;
    }

    public CustomPortalBuilder postTeleportEvent(Consumer<Entity> event) {
        this.portalLink.setPostTeleportEvent(event);
        return this;
    }

    public CustomPortalBuilder prePortalIgniteEvent(BiFunction<BlockPos, PortalIgnitionSource, Boolean> event) {
        this.portalLink.setPrePortalIgniteEvent(event);
        return this;
    }

    public CustomPortalBuilder postPortalIgniteEvent(BiConsumer<BlockPos, PortalIgnitionSource> event) {
        this.portalLink.setPostPortalIgniteEvent(event);
        return this;
    }

    public CustomPortalBuilder travelSound(ResourceLocation travelSoundLocation, Function<Entity, Float> travelSoundVolume, Function<Entity, Float> travelSoundPitch) {
        this.portalLink.setTravelSound(travelSoundLocation, travelSoundVolume, travelSoundPitch);
        return this;
    }

    public CustomPortalBuilder triggerSound(ResourceLocation triggerSoundLocation, Function<Entity, Float> triggerSoundVolume, Function<Entity, Float> triggerSoundPitch) {
        this.portalLink.setTriggerSound(triggerSoundLocation, triggerSoundVolume, triggerSoundPitch);
        return this;
    }

    public CustomPortalBuilder ambientSound(ResourceLocation ambientSoundLocation, Function<Level, Float> ambientSoundVolume, Function<Level, Float> ambientSoundPitch) {
        this.portalLink.setAmbientSound(ambientSoundLocation, ambientSoundVolume, ambientSoundPitch);
        return this;
    }

    public CustomPortalBuilder portalParticle(BiFunction<Level, BlockPos, ParticleOptions> particleFunction) {
        this.portalLink.portalParticle = particleFunction;
        return this;
    }
}

