/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.mixin.client;

import net.kyrptonaught.customportalapi.CustomPortalBlock;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.mixin.client.PortalManagerAccessor;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.level.block.Portal;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={LocalPlayer.class})
public class LocalPlayerMixin {
    @ModifyArg(method={"handlePortalTransitionEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/sounds/SoundManager;play(Lnet/minecraft/client/resources/sounds/SoundInstance;)Lnet/minecraft/client/sounds/SoundEngine$PlayResult;"))
    public SoundInstance playSound(SoundInstance original) {
        SoundInstance triggerSound = this.customportalapi_reforged$getTriggerSound((LocalPlayer)this);
        if (triggerSound != null) {
            return triggerSound;
        }
        return original;
    }

    @Unique
    @Nullable
    private SoundInstance customportalapi_reforged$getTriggerSound(LocalPlayer player) {
        BlockPos portalPos;
        PortalProcessor portalManager = player.portalProcess;
        Portal portalBlock = portalManager != null && portalManager.isInsidePortalThisTick() ? ((PortalManagerAccessor)portalManager).getPortal() : null;
        BlockPos blockPos = portalPos = portalManager != null && portalManager.isInsidePortalThisTick() ? ((PortalManagerAccessor)portalManager).getEntryPosition() : null;
        if (portalBlock == null) {
            return null;
        }
        if (portalBlock instanceof CustomPortalBlock) {
            PortalLink link;
            CustomPortalBlock customportalblock = (CustomPortalBlock)portalBlock;
            if (portalPos != null && (link = CustomPortalsMod.getPortalLinkFromBase(customportalblock.getPortalBase(player.level(), portalPos))) != null && link.triggerSoundLocation != null) {
                return SimpleSoundInstance.forLocalAmbience((SoundEvent)((SoundEvent)((Holder.Reference)BuiltInRegistries.SOUND_EVENT.get(link.triggerSoundLocation).orElseThrow()).value()), (float)link.triggerSoundVolume.apply((Entity)player).floatValue(), (float)link.triggerSoundPitch.apply((Entity)player).floatValue());
            }
        }
        return null;
    }
}

