/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.PortalIgnitionSource;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class PortalIgniter {
    public static boolean attemptPortalLight(Level level, BlockPos portalPos, PortalIgnitionSource ignitionSource) {
        return PortalIgniter.attemptPortalLight(level, portalPos, CustomPortalHelper.getClosestFrameBlock(level, portalPos), ignitionSource);
    }

    public static boolean attemptPortalLight(Level level, BlockPos portalPos, BlockPos framePos, PortalIgnitionSource ignitionSource) {
        Block foundationBlock = level.getBlockState(framePos).getBlock();
        PortalLink link = CustomPortalsMod.getPortalLinkFromBase(foundationBlock);
        if (link == null || !link.doesIgnitionMatch(ignitionSource) || !link.canLightInDim(level.dimension().location())) {
            return false;
        }
        return PortalIgniter.attemptToLightPortal(link, level, portalPos, foundationBlock, ignitionSource);
    }

    private static boolean attemptToLightPortal(PortalLink link, Level level, BlockPos pos, Block foundationBlock, PortalIgnitionSource ignitionSource) {
        Optional<PortalFrameTester> optional = link.getFrameTester().getNewPortal((LevelAccessor)level, pos, Direction.Axis.X, foundationBlock);
        if (optional.isPresent()) {
            if (optional.get().isRequestedSize(link.strictWidth, link.strictHeight) && link.getPrePortalIgniteEvent().apply(pos, ignitionSource).booleanValue()) {
                optional.get().lightPortal(foundationBlock);
                link.getPostPortalIgniteEvent().accept(pos, ignitionSource);
            }
            return true;
        }
        return false;
    }
}

