/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal;

import java.util.HashSet;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class PortalIgnitionSource {
    public static final PortalIgnitionSource FIRE = new PortalIgnitionSource(SourceType.BLOCK_PLACED, BuiltInRegistries.BLOCK.getKey((Object)Blocks.FIRE));
    public static final PortalIgnitionSource WATER = PortalIgnitionSource.fromFluid((Fluid)Fluids.WATER);
    private static final HashSet<Item> USE_ITEMS = new HashSet();
    public final SourceType sourceType;
    public final ResourceLocation ignitionSourceID;
    @Nullable
    public Player player;

    private PortalIgnitionSource(SourceType sourceType, ResourceLocation ignitionSourceID) {
        this.sourceType = sourceType;
        this.ignitionSourceID = ignitionSourceID;
    }

    public static PortalIgnitionSource fromItem(Item item) {
        USE_ITEMS.add(item);
        return new PortalIgnitionSource(SourceType.USE_ITEM, BuiltInRegistries.ITEM.getKey((Object)item));
    }

    public static PortalIgnitionSource fromFluid(Fluid fluid) {
        return new PortalIgnitionSource(SourceType.FLUID, BuiltInRegistries.FLUID.getKey((Object)fluid));
    }

    public static PortalIgnitionSource fromCustomSource(ResourceLocation ignitionSourceID) {
        return new PortalIgnitionSource(SourceType.CUSTOM, ignitionSourceID);
    }

    public static boolean isRegisteredIgnitionSourceWith(Item item) {
        return USE_ITEMS.contains(item);
    }

    public PortalIgnitionSource withPlayer(Player player) {
        this.player = player;
        return this;
    }

    public boolean isWater() {
        return Optional.of(BuiltInRegistries.FLUID.get(this.ignitionSourceID)).filter(fluid -> fluid.isPresent() && ((Holder.Reference)fluid.orElseThrow()).is(FluidTags.WATER)).isPresent();
    }

    public boolean isLava() {
        return Optional.of(BuiltInRegistries.FLUID.get(this.ignitionSourceID)).filter(fluid -> fluid.isPresent() && ((Holder.Reference)fluid.orElseThrow()).is(FluidTags.LAVA)).isPresent();
    }

    public static enum SourceType {
        USE_ITEM,
        BLOCK_PLACED,
        FLUID,
        CUSTOM;

    }
}

