/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.frame;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.function.Predicate;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FlatPortalFrameTester
extends PortalFrameTester {
    protected final int maxXSize = 21;
    protected final int maxZSize = 21;
    protected int xSize = -1;
    protected int zSize = -1;

    @Override
    public FlatPortalFrameTester init(LevelAccessor level, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        this.VALID_FRAME = Sets.newHashSet((Object[])foundations);
        this.levelAccessor = level;
        this.lowerCorner = this.getLowerCorner(blockPos, Direction.Axis.X, Direction.Axis.Z);
        this.foundPortalBlocks = 0;
        if (this.lowerCorner == null) {
            this.lowerCorner = blockPos;
            this.zSize = 1;
            this.xSize = 1;
        } else {
            this.xSize = this.getSize(Direction.Axis.X, 2, 21);
            if (this.xSize > 0) {
                this.zSize = this.getSize(Direction.Axis.Z, 2, 21);
                if (this.checkForValidFrame(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize)) {
                    this.countExistingPortalBlocks(Direction.Axis.X, Direction.Axis.Z, this.xSize, this.zSize);
                } else {
                    this.lowerCorner = null;
                    this.zSize = 1;
                    this.xSize = 1;
                }
            }
        }
        return this;
    }

    @Override
    public Optional<PortalFrameTester> getNewPortal(LevelAccessor level, BlockPos blockPos, Direction.Axis axis, Block ... foundations) {
        return this.getOrEmpty(level, blockPos, areaHelper -> areaHelper.isValidFrame() && areaHelper.foundPortalBlocks == 0, axis, foundations);
    }

    @Override
    public Optional<PortalFrameTester> getOrEmpty(LevelAccessor level, BlockPos blockPos, Predicate<PortalFrameTester> predicate, Direction.Axis axis, Block ... foundations) {
        return Optional.of(new FlatPortalFrameTester().init(level, blockPos, axis, foundations)).filter(predicate);
    }

    @Override
    public boolean isAlreadyLitPortalFrame() {
        return this.isValidFrame() && this.foundPortalBlocks == this.xSize * this.zSize;
    }

    @Override
    public boolean isValidFrame() {
        return this.lowerCorner != null && this.xSize >= 2 && this.zSize >= 2 && this.xSize < 21 && this.zSize < 21;
    }

    @Override
    public void lightPortal(Block frameBlock) {
        if (this.lowerCorner == null) {
            return;
        }
        PortalLink link = CustomPortalsMod.getPortalLinkFromBase(frameBlock);
        BlockState blockState = CustomPortalHelper.blockWithAxis(link != null ? link.portalBlock.defaultBlockState() : CustomPortalsMod.CUSTOM_PORTAL_BLOCK.get().defaultBlockState(), Direction.Axis.Y);
        BlockPos.betweenClosed((BlockPos)this.lowerCorner, (BlockPos)this.lowerCorner.relative(Direction.Axis.X, this.xSize - 1).relative(Direction.Axis.Z, this.zSize - 1)).forEach(blockPos -> this.levelAccessor.setBlock(blockPos, blockState, 18));
    }

    @Override
    public void createPortal(Level level, BlockPos pos, BlockState frameBlock, Direction.Axis axis) {
        int i;
        for (i = -1; i < 3; ++i) {
            level.setBlockAndUpdate(pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, -1), frameBlock);
            level.setBlockAndUpdate(pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 2), frameBlock);
            level.setBlockAndUpdate(pos.relative(Direction.Axis.Z, i).relative(Direction.Axis.X, -1), frameBlock);
            level.setBlockAndUpdate(pos.relative(Direction.Axis.Z, i).relative(Direction.Axis.X, 2), frameBlock);
        }
        for (i = 0; i < 2; ++i) {
            this.placeLandingPad(level, pos.relative(Direction.Axis.X, i).below(), frameBlock);
            this.placeLandingPad(level, pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 1).below(), frameBlock);
            this.fillAirAroundPortal(level, pos.relative(Direction.Axis.X, i).above());
            this.fillAirAroundPortal(level, pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 1).above());
            this.fillAirAroundPortal(level, pos.relative(Direction.Axis.X, i).above(2));
            this.fillAirAroundPortal(level, pos.relative(Direction.Axis.X, i).relative(Direction.Axis.Z, 1).above(2));
        }
        this.lowerCorner = pos;
        this.zSize = 2;
        this.xSize = 2;
        this.levelAccessor = level;
        this.foundPortalBlocks = 4;
        this.lightPortal(frameBlock.getBlock());
    }

    protected void fillAirAroundPortal(Level level, BlockPos pos) {
        if (level.getBlockState(pos).isSolid()) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 16);
        }
    }

    protected void placeLandingPad(Level level, BlockPos pos, BlockState frameBlock) {
        if (!level.getBlockState(pos).isSolid()) {
            level.setBlockAndUpdate(pos, frameBlock);
        }
    }

    @Override
    public boolean isRequestedSize(int attemptWidth, int attemptHeight) {
        return (this.xSize == attemptWidth || attemptHeight == 0) && this.zSize == attemptHeight || attemptWidth == 0 || (this.xSize == attemptHeight || attemptHeight == 0) && this.zSize == attemptWidth;
    }

    @Override
    @Nullable
    public BlockUtil.FoundRectangle getRectangle() {
        if (this.lowerCorner == null) {
            return null;
        }
        return new BlockUtil.FoundRectangle(this.lowerCorner, this.xSize, this.zSize);
    }

    @Override
    @Nullable
    public BlockPos doesPortalFitAt(Level level, BlockPos attemptPos, Direction.Axis axis) {
        BlockUtil.FoundRectangle rect = BlockUtil.getLargestRectangleAround((BlockPos)attemptPos.above(), (Direction.Axis)Direction.Axis.X, (int)4, (Direction.Axis)Direction.Axis.Z, (int)4, blockPos -> level.getBlockState(blockPos).isSolid() && !level.getBlockState(blockPos.above()).isSolid() && !level.getBlockState(blockPos.above()).liquid() && !level.getBlockState(blockPos.above(2)).isSolid() && !level.getBlockState(blockPos.above(2)).liquid());
        return rect.axis1Size >= 4 && rect.axis2Size >= 4 ? rect.minCorner : null;
    }

    @Override
    public Vec3 getEntityOffsetInPortal(BlockUtil.FoundRectangle rect, Entity entity, Direction.Axis portalAxis) {
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        double xSize = (float)rect.axis1Size - entityDimensions.width();
        double zSize = (float)rect.axis2Size - entityDimensions.width();
        double deltaX = Mth.inverseLerp((double)entity.getX(), (double)rect.minCorner.getX(), (double)((double)rect.minCorner.getX() + xSize));
        double deltaY = Mth.inverseLerp((double)entity.getY(), (double)((double)rect.minCorner.getY() - 1.0), (double)((double)rect.minCorner.getY() + 1.0));
        double deltaZ = Mth.inverseLerp((double)entity.getZ(), (double)rect.minCorner.getZ(), (double)((double)rect.minCorner.getZ() + zSize));
        return new Vec3(deltaX, deltaY, deltaZ);
    }

    @Override
    public TeleportTransition getTPTargetInPortal(ServerLevel serverLevel, BlockUtil.FoundRectangle portalRect, Direction.Axis portalAxis, Vec3 prevOffset, Entity entity, PortalLink link) {
        EntityDimensions entityDimensions = entity.getDimensions(entity.getPose());
        float xSize = (float)portalRect.axis1Size - entityDimensions.width();
        float zSize = (float)portalRect.axis2Size - entityDimensions.width();
        double x = Mth.lerp((double)prevOffset.x, (double)portalRect.minCorner.getX(), (double)((float)portalRect.minCorner.getX() + xSize));
        double z = Mth.lerp((double)prevOffset.z, (double)portalRect.minCorner.getZ(), (double)((float)portalRect.minCorner.getZ() + zSize));
        TeleportTransition.PostTeleportTransition post = TeleportTransition.DO_NOTHING.then(entity1 -> {
            link.playTravelSound(entity1);
            entity1.placePortalTicket(portalRect.minCorner);
            link.executePostTeleportEvent(entity1);
        });
        return new TeleportTransition(serverLevel, new Vec3(x, (double)portalRect.minCorner.getY() + 1.0, z), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), post);
    }
}

