/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.portal.linking;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.kyrptonaught.customportalapi.portal.linking.DimensionLink;
import net.kyrptonaught.customportalapi.portal.linking.DimensionalBlockPos;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import org.jetbrains.annotations.Nullable;

public class PortalLinkingStorage
extends SavedData {
    public static final Codec<PortalLinkingStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionLink.CODEC.listOf().fieldOf("dimensionLinks").forGetter(PortalLinkingStorage::getDimensionLinks)).apply((Applicative)instance, PortalLinkingStorage::new));
    public static final SavedDataType<PortalLinkingStorage> TYPE = new SavedDataType("customportalapi_dimension_links", PortalLinkingStorage::new, CODEC, null);
    private final List<DimensionLink> dimensionLinks = new ArrayList<DimensionLink>();

    public PortalLinkingStorage() {
    }

    public PortalLinkingStorage(List<DimensionLink> portalLinks) {
        this.dimensionLinks.addAll(portalLinks);
    }

    public List<DimensionLink> getDimensionLinks() {
        return this.dimensionLinks;
    }

    @Nullable
    public DimensionalBlockPos getDestination(BlockPos portalFramePos, ResourceKey<Level> dim) {
        for (DimensionLink link : this.dimensionLinks) {
            if (!link.fromPos().dimension().equals((Object)dim.location()) || !link.fromPos().pos().equals((Object)portalFramePos)) continue;
            return link.toPos();
        }
        return null;
    }

    public void createLink(BlockPos portalFramePos, ResourceKey<Level> fromDim, BlockPos destPortalFramePos, ResourceKey<Level> destDim) {
        this.addLink(portalFramePos, fromDim, destPortalFramePos, destDim);
        this.addLink(destPortalFramePos, destDim, portalFramePos, fromDim);
    }

    private void addLink(BlockPos portalFramePos, ResourceLocation fromDim, BlockPos destPortalFramePos, ResourceLocation destDim) {
        boolean found = false;
        for (DimensionLink link : this.dimensionLinks) {
            if (!link.fromPos().dimension().equals((Object)fromDim) || !link.fromPos().pos().equals((Object)portalFramePos)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.dimensionLinks.add(new DimensionLink(new DimensionalBlockPos(fromDim, portalFramePos), new DimensionalBlockPos(destDim, destPortalFramePos)));
        }
    }

    private void addLink(BlockPos portalFramePos, ResourceKey<Level> fromDim, BlockPos destPortalFramePos, ResourceKey<Level> destDim) {
        this.addLink(portalFramePos, fromDim.location(), destPortalFramePos, destDim.location());
    }

    public boolean isDirty() {
        return true;
    }
}

