/*
 * Decompiled with CFR 0.152.
 */
package net.kyrptonaught.customportalapi.util;

import java.util.Optional;
import net.kyrptonaught.customportalapi.CustomPortalsMod;
import net.kyrptonaught.customportalapi.portal.frame.PortalFrameTester;
import net.kyrptonaught.customportalapi.portal.linking.DimensionalBlockPos;
import net.kyrptonaught.customportalapi.util.CustomPortalHelper;
import net.kyrptonaught.customportalapi.util.PortalLink;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CustomTeleporter {
    @Nullable
    public static TeleportTransition attemptTeleport(Level level, Entity entity, Block portalBase, BlockPos portalPos) {
        PortalLink link = CustomPortalsMod.getPortalLinkFromBase(portalBase);
        if (link == null) {
            return null;
        }
        if (!link.getPreTeleportEvent().apply(entity).booleanValue()) {
            return null;
        }
        ResourceKey<Level> destinationKey = level.dimension() == CustomPortalsMod.dimensions.get(link.targetDimensionLocation) ? CustomPortalsMod.dimensions.get(link.returnDimensionLocation) : CustomPortalsMod.dimensions.get(link.targetDimensionLocation);
        ServerLevel destination = ((ServerLevel)level).getServer().getLevel(destinationKey);
        if (destination == null) {
            return null;
        }
        if (!entity.canUsePortal(false)) {
            return null;
        }
        return CustomTeleporter.createCustomTeleportTarget(destination, entity, portalPos, portalBase, link, link.getFrameTester());
    }

    @Nullable
    private static TeleportTransition createCustomTeleportTarget(ServerLevel destinationLevel, Entity entity, BlockPos enteredPortalPos, Block frameBlock, PortalLink link, PortalFrameTester frameTester) {
        PortalFrameTester portalFrameTester;
        if (CustomPortalsMod.portalLinkingStorage == null) {
            return null;
        }
        Direction.Axis portalAxis = CustomPortalHelper.getAxisFrom(entity.level().getBlockState(enteredPortalPos));
        BlockUtil.FoundRectangle fromPortalRectangle = frameTester.init((LevelAccessor)entity.level(), enteredPortalPos, portalAxis, frameBlock).getRectangle();
        if (fromPortalRectangle == null) {
            return null;
        }
        DimensionalBlockPos destinationPos = CustomPortalsMod.portalLinkingStorage.getDestination(fromPortalRectangle.minCorner, (ResourceKey<Level>)entity.level().dimension());
        if (destinationPos != null && destinationPos.dimension().equals((Object)destinationLevel.dimension().location()) && (portalFrameTester = frameTester.init((LevelAccessor)destinationLevel, destinationPos.pos(), portalAxis, frameBlock)).isValidFrame() && portalFrameTester.getRectangle() != null) {
            if (!portalFrameTester.isAlreadyLitPortalFrame()) {
                portalFrameTester.lightPortal(frameBlock);
            }
            return portalFrameTester.getTPTargetInPortal(destinationLevel, portalFrameTester.getRectangle(), portalAxis, portalFrameTester.getEntityOffsetInPortal(fromPortalRectangle, entity, portalAxis), entity, link);
        }
        return CustomTeleporter.createDestinationPortal(destinationLevel, entity, portalAxis, fromPortalRectangle, frameBlock.defaultBlockState(), link);
    }

    @Nullable
    private static TeleportTransition createDestinationPortal(ServerLevel destination, Entity entity, Direction.Axis axis, BlockUtil.FoundRectangle portalFramePos, BlockState frameBlock, PortalLink link) {
        if (CustomPortalsMod.portalLinkingStorage == null) {
            return null;
        }
        WorldBorder worldBorder = destination.getWorldBorder();
        double xMin = Math.max(-2.9999872E7, worldBorder.getMinX() + 16.0);
        double zMin = Math.max(-2.9999872E7, worldBorder.getMinZ() + 16.0);
        double xMax = Math.min(2.9999872E7, worldBorder.getMaxX() - 16.0);
        double zMax = Math.min(2.9999872E7, worldBorder.getMaxZ() - 16.0);
        double scaleFactor = DimensionType.getTeleportationScale((DimensionType)entity.level().dimensionType(), (DimensionType)destination.dimensionType());
        BlockPos blockPos = BlockPos.containing((double)Mth.clamp((double)(entity.getX() * scaleFactor), (double)xMin, (double)xMax), (double)entity.blockPosition().getY(), (double)Mth.clamp((double)(entity.getZ() * scaleFactor), (double)zMin, (double)zMax));
        Optional<BlockUtil.FoundRectangle> portal = CustomTeleporter.buildDestinationPortal(destination, blockPos, frameBlock, axis, link);
        if (portal.isPresent()) {
            PortalFrameTester portalFrameTester = link.getFrameTester();
            CustomPortalsMod.portalLinkingStorage.createLink(portalFramePos.minCorner, (ResourceKey<Level>)entity.level().dimension(), portal.get().minCorner, (ResourceKey<Level>)destination.dimension());
            return portalFrameTester.getTPTargetInPortal(destination, portal.get(), axis, portalFrameTester.getEntityOffsetInPortal(portalFramePos, entity, axis), entity, link);
        }
        return CustomTeleporter.failedToFindValidTarget(destination, entity, blockPos);
    }

    private static TeleportTransition failedToFindValidTarget(ServerLevel level, Entity entity, BlockPos pos) {
        CustomPortalsMod.LOGGER.error("Unable to find a valid teleport location, forced to place on top of world");
        level.getBlockState(pos);
        BlockPos destinationPos = level.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, pos);
        return new TeleportTransition(level, new Vec3((double)destinationPos.getX() + 0.5, (double)destinationPos.getY(), (double)destinationPos.getZ() + 0.5), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING);
    }

    public static Optional<BlockUtil.FoundRectangle> buildDestinationPortal(ServerLevel serverLevel, BlockPos blockPos, BlockState frameBlock, Direction.Axis axis, PortalLink link) {
        PortalFrameTester portalFrameTester = link.getFrameTester();
        int topY = Math.min(serverLevel.getMaxY(), serverLevel.getMinY() + serverLevel.getLogicalHeight()) - 5;
        int bottomY = serverLevel.getMinY() + 5;
        if (serverLevel.dimension().location().equals((Object)link.targetDimensionLocation)) {
            if (link.portalSearchYTop != Integer.MIN_VALUE) {
                topY = link.portalSearchYTop;
            }
            if (link.portalSearchYBottom != Integer.MIN_VALUE) {
                bottomY = link.portalSearchYBottom;
            }
        } else {
            if (link.returnPortalSearchYTop != Integer.MIN_VALUE) {
                topY = link.returnPortalSearchYTop;
            }
            if (link.returnPortalSearchYBottom != Integer.MIN_VALUE) {
                bottomY = link.returnPortalSearchYBottom;
            }
        }
        for (BlockPos.MutableBlockPos mutable : BlockPos.spiralAround((BlockPos)blockPos, (int)32, (Direction)Direction.WEST, (Direction)Direction.SOUTH)) {
            BlockPos testingPos = mutable.immutable();
            if (!serverLevel.getWorldBorder().isWithinBounds(testingPos)) continue;
            for (int y = topY; y >= bottomY; --y) {
                BlockPos testRect;
                if (!serverLevel.getBlockState(testingPos.atY(y)).isSolid() || (testRect = portalFrameTester.doesPortalFitAt((Level)serverLevel, testingPos.atY(y + 1), axis)) == null) continue;
                portalFrameTester.createPortal((Level)serverLevel, testRect, frameBlock, axis);
                return Optional.ofNullable(portalFrameTester.getRectangle());
            }
        }
        portalFrameTester.createPortal((Level)serverLevel, blockPos, frameBlock, axis);
        return Optional.ofNullable(portalFrameTester.getRectangle());
    }
}

