/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt;

import com.minecraft.manhunt.commands.HunterCommand;
import com.minecraft.manhunt.commands.ManhuntCommand;
import com.minecraft.manhunt.commands.RunnerCommand;
import com.minecraft.manhunt.commands.SpectateCommand;
import com.minecraft.manhunt.config.ConfigManager;
import com.minecraft.manhunt.game.GameManager;
import com.minecraft.manhunt.listeners.AdvancementListener;
import com.minecraft.manhunt.listeners.CompassListener;
import com.minecraft.manhunt.listeners.GameListener;
import com.minecraft.manhunt.listeners.PlayerListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ManhuntPlugin
extends JavaPlugin {
    private static ManhuntPlugin instance;
    private GameManager gameManager;
    private ConfigManager configManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.gameManager = new GameManager(this);
        this.registerCommands();
        this.registerListeners();
        this.getLogger().info("Manhunt Plugin has been enabled!");
    }

    public void onDisable() {
        if (this.gameManager != null) {
            this.gameManager.endGame();
        }
        this.getLogger().info("Manhunt Plugin has been disabled!");
    }

    private void registerCommands() {
        this.getCommand("manhunt").setExecutor((CommandExecutor)new ManhuntCommand(this));
        this.getCommand("hunter").setExecutor((CommandExecutor)new HunterCommand(this));
        this.getCommand("runner").setExecutor((CommandExecutor)new RunnerCommand(this));
        this.getCommand("spectate").setExecutor((CommandExecutor)new SpectateCommand(this));
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GameListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CompassListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AdvancementListener(this), (Plugin)this);
    }

    public static ManhuntPlugin getInstance() {
        return instance;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }
}

