/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.commands;

import com.minecraft.manhunt.ManhuntPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ManhuntCommand
implements CommandExecutor,
TabCompleter {
    private final ManhuntPlugin plugin;
    private final List<String> mainCommands = Arrays.asList("start", "stop", "join", "leave", "hunter", "runner", "config", "spectate", "revive", "list");
    private final List<String> configCommands = Arrays.asList("graceperiod", "suddendeath", "netherite", "revivetime", "deathswap", "runnerbuffs");

    public ManhuntCommand(ManhuntPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cThis command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.sendHelpMessage(player);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "start": {
                if (!player.hasPermission("manhunt.admin")) {
                    player.sendMessage("\u00a7cYou don't have permission to start the game!");
                    return true;
                }
                this.plugin.getGameManager().startGame();
                break;
            }
            case "stop": {
                if (!player.hasPermission("manhunt.admin")) {
                    player.sendMessage("\u00a7cYou don't have permission to stop the game!");
                    return true;
                }
                this.plugin.getGameManager().endGame();
                break;
            }
            case "join": {
                this.plugin.getGameManager().addHunter(player);
                break;
            }
            case "leave": {
                this.plugin.getGameManager().addSpectator(player);
                break;
            }
            case "hunter": {
                this.plugin.getGameManager().addHunter(player);
                break;
            }
            case "runner": {
                this.plugin.getGameManager().addRunner(player);
                break;
            }
            case "spectate": {
                this.plugin.getGameManager().addSpectator(player);
                break;
            }
            case "config": {
                if (!player.hasPermission("manhunt.admin")) {
                    player.sendMessage("\u00a7cYou don't have permission to modify config!");
                    return true;
                }
                this.handleConfigCommand(player, args);
                break;
            }
            case "list": {
                this.sendGameStatus(player);
                break;
            }
            default: {
                this.sendHelpMessage(player);
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String partialCommand = args[0].toLowerCase();
            completions.addAll(this.mainCommands.stream().filter(cmd -> cmd.startsWith(partialCommand)).collect(Collectors.toList()));
        } else if (args.length == 2 && args[0].equalsIgnoreCase("config")) {
            String partialConfig = args[1].toLowerCase();
            completions.addAll(this.configCommands.stream().filter(cmd -> cmd.startsWith(partialConfig)).collect(Collectors.toList()));
        }
        return completions;
    }

    private void handleConfigCommand(Player player, String[] args) {
        String setting;
        if (args.length < 2) {
            player.sendMessage("\u00a7cUsage: /manhunt config <setting> <value>");
            return;
        }
        switch (setting = args[1].toLowerCase()) {
            case "graceperiod": {
                if (args.length != 3) break;
                try {
                    int seconds = Integer.parseInt(args[2]);
                    this.plugin.getConfigManager().setGracePeriod(seconds);
                    player.sendMessage("\u00a7aGrace period set to " + seconds + " seconds!");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid number format!");
                }
                break;
            }
            case "suddendeath": {
                if (args.length != 3) break;
                try {
                    int minutes = Integer.parseInt(args[2]);
                    this.plugin.getConfigManager().setSuddenDeathTime(minutes);
                    player.sendMessage("\u00a7aSudden death time set to " + minutes + " minutes!");
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid number format!");
                }
                break;
            }
            case "netherite": {
                if (args.length != 3) break;
                boolean enabled = Boolean.parseBoolean(args[2]);
                this.plugin.getConfigManager().setNetheriteEnabled(enabled);
                player.sendMessage("\u00a7aNetherite " + (enabled ? "enabled" : "disabled") + "!");
                break;
            }
            default: {
                player.sendMessage("\u00a7cUnknown config option!");
            }
        }
    }

    private void sendHelpMessage(Player player) {
        player.sendMessage("\u00a76=== Manhunt Commands ===");
        player.sendMessage("\u00a7e/manhunt start \u00a77- Start the game");
        player.sendMessage("\u00a7e/manhunt stop \u00a77- Stop the game");
        player.sendMessage("\u00a7e/manhunt join \u00a77- Join as hunter");
        player.sendMessage("\u00a7e/manhunt leave \u00a77- Leave the game");
        player.sendMessage("\u00a7e/manhunt hunter \u00a77- Join as hunter");
        player.sendMessage("\u00a7e/manhunt runner \u00a77- Join as runner");
        player.sendMessage("\u00a7e/manhunt spectate \u00a77- Join as spectator");
        player.sendMessage("\u00a7e/manhunt list \u00a77- List all players and their roles");
        if (player.hasPermission("manhunt.admin")) {
            player.sendMessage("\u00a7e/manhunt config \u00a77- Modify game settings");
        }
    }

    private void sendGameStatus(Player player) {
        player.sendMessage("\u00a76=== Game Status ===");
        player.sendMessage("\u00a7eGame Running: \u00a77" + this.plugin.getGameManager().isGameRunning());
        player.sendMessage("\u00a7eGrace Period: \u00a77" + this.plugin.getGameManager().isInGracePeriod());
        player.sendMessage("\u00a76=== Hunters ===");
        this.plugin.getGameManager().getHunters().forEach(uuid -> {
            Player hunter = this.plugin.getServer().getPlayer(uuid);
            if (hunter != null) {
                player.sendMessage("\u00a77- " + hunter.getName());
            }
        });
        player.sendMessage("\u00a76=== Runners ===");
        this.plugin.getGameManager().getRunners().forEach(uuid -> {
            Player runner = this.plugin.getServer().getPlayer(uuid);
            if (runner != null) {
                player.sendMessage("\u00a77- " + runner.getName());
            }
        });
        player.sendMessage("\u00a76=== Spectators ===");
        this.plugin.getGameManager().getSpectators().forEach(uuid -> {
            Player spectator = this.plugin.getServer().getPlayer(uuid);
            if (spectator != null) {
                player.sendMessage("\u00a77- " + spectator.getName());
            }
        });
    }
}

