/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.config;

import com.minecraft.manhunt.ManhuntPlugin;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final ManhuntPlugin plugin;
    private FileConfiguration config;
    private int gracePeriod;
    private int suddenDeathTime;
    private boolean netheriteEnabled;
    private boolean hunterReviveEnabled;
    private int hunterReviveTime;
    private boolean deathSwapEnabled;
    private int deathSwapInterval;
    private double runnerHealthBonus;
    private double runnerSpeedBonus;

    public ConfigManager(ManhuntPlugin plugin) {
        this.plugin = plugin;
        this.loadConfig();
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.gracePeriod = this.config.getInt("grace-period", 30);
        this.suddenDeathTime = this.config.getInt("sudden-death-time", 60);
        this.netheriteEnabled = this.config.getBoolean("netherite-enabled", true);
        this.hunterReviveEnabled = this.config.getBoolean("hunter-revive.enabled", true);
        this.hunterReviveTime = this.config.getInt("hunter-revive.time", 300);
        this.deathSwapEnabled = this.config.getBoolean("death-swap.enabled", false);
        this.deathSwapInterval = this.config.getInt("death-swap.interval", 300);
        this.runnerHealthBonus = this.config.getDouble("runner-buffs.health", 0.0);
        this.runnerSpeedBonus = this.config.getDouble("runner-buffs.speed", 0.0);
    }

    public void saveConfig() {
        this.config.set("grace-period", (Object)this.gracePeriod);
        this.config.set("sudden-death-time", (Object)this.suddenDeathTime);
        this.config.set("netherite-enabled", (Object)this.netheriteEnabled);
        this.config.set("hunter-revive.enabled", (Object)this.hunterReviveEnabled);
        this.config.set("hunter-revive.time", (Object)this.hunterReviveTime);
        this.config.set("death-swap.enabled", (Object)this.deathSwapEnabled);
        this.config.set("death-swap.interval", (Object)this.deathSwapInterval);
        this.config.set("runner-buffs.health", (Object)this.runnerHealthBonus);
        this.config.set("runner-buffs.speed", (Object)this.runnerSpeedBonus);
        this.plugin.saveConfig();
    }

    public void setGracePeriod(int seconds) {
        this.gracePeriod = seconds;
        this.saveConfig();
    }

    public void setSuddenDeathTime(int minutes) {
        this.suddenDeathTime = minutes;
        this.saveConfig();
    }

    public void setNetheriteEnabled(boolean enabled) {
        this.netheriteEnabled = enabled;
        this.saveConfig();
    }

    public void setHunterReviveEnabled(boolean enabled) {
        this.hunterReviveEnabled = enabled;
        this.saveConfig();
    }

    public void setHunterReviveTime(int seconds) {
        this.hunterReviveTime = seconds;
        this.saveConfig();
    }

    public void setDeathSwapEnabled(boolean enabled) {
        this.deathSwapEnabled = enabled;
        this.saveConfig();
    }

    public void setDeathSwapInterval(int seconds) {
        this.deathSwapInterval = seconds;
        this.saveConfig();
    }

    public void setRunnerHealthBonus(double bonus) {
        this.runnerHealthBonus = bonus;
        this.saveConfig();
    }

    public void setRunnerSpeedBonus(double bonus) {
        this.runnerSpeedBonus = bonus;
        this.saveConfig();
    }

    public int getGracePeriod() {
        return this.gracePeriod;
    }

    public int getSuddenDeathTime() {
        return this.suddenDeathTime;
    }

    public boolean isNetheriteEnabled() {
        return this.netheriteEnabled;
    }

    public boolean isHunterReviveEnabled() {
        return this.hunterReviveEnabled;
    }

    public int getHunterReviveTime() {
        return this.hunterReviveTime;
    }

    public boolean isDeathSwapEnabled() {
        return this.deathSwapEnabled;
    }

    public int getDeathSwapInterval() {
        return this.deathSwapInterval;
    }

    public double getRunnerHealthBonus() {
        return this.runnerHealthBonus;
    }

    public double getRunnerSpeedBonus() {
        return this.runnerSpeedBonus;
    }
}

