/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.game;

import com.minecraft.manhunt.ManhuntPlugin;
import com.minecraft.manhunt.game.GameManager;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CompassManager {
    private static final NamespacedKey TRACKING_COMPASS_KEY = new NamespacedKey((Plugin)ManhuntPlugin.getInstance(), "tracking_compass");

    public static ItemStack createTrackingCompass() {
        ItemStack compass = new ItemStack(Material.COMPASS);
        CompassMeta meta = (CompassMeta)compass.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7c\u00a7lRunner Tracker");
            meta.setLore(Arrays.asList("\u00a77Right-click to track the nearest runner", "\u00a77Works across all dimensions"));
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(TRACKING_COMPASS_KEY, PersistentDataType.BYTE, (Object)1);
            compass.setItemMeta((ItemMeta)meta);
        }
        return compass;
    }

    public static boolean isTrackingCompass(ItemStack item) {
        if (item == null || item.getType() != Material.COMPASS) {
            return false;
        }
        CompassMeta meta = (CompassMeta)item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(TRACKING_COMPASS_KEY, PersistentDataType.BYTE);
    }

    public static void updateCompass(Player hunter, Player target) {
        ItemStack compass = hunter.getInventory().getItemInMainHand();
        if (!CompassManager.isTrackingCompass(compass) && !CompassManager.isTrackingCompass(compass = hunter.getInventory().getItemInOffHand())) {
            return;
        }
        CompassMeta meta = (CompassMeta)compass.getItemMeta();
        if (meta == null) {
            return;
        }
        World hunterWorld = hunter.getWorld();
        World targetWorld = target.getWorld();
        if (hunterWorld.getEnvironment() == targetWorld.getEnvironment()) {
            meta.setLodestone(target.getLocation());
            meta.setLodestoneTracked(false);
            meta.setDisplayName("\u00a7c\u00a7lTracking: " + target.getName());
        } else {
            String dimension = CompassManager.getDimensionName(targetWorld.getEnvironment());
            meta.setDisplayName("\u00a7c\u00a7lRunner is in " + dimension);
            meta.setLodestone(hunterWorld.getSpawnLocation());
        }
        compass.setItemMeta((ItemMeta)meta);
    }

    private static String getDimensionName(World.Environment environment) {
        switch (environment) {
            case NETHER: {
                return "The Nether";
            }
            case THE_END: {
                return "The End";
            }
        }
        return "Overworld";
    }

    public static Player getNearestRunner(Player hunter) {
        GameManager gameManager = ManhuntPlugin.getInstance().getGameManager();
        Player nearest = null;
        double nearestDistance = Double.MAX_VALUE;
        for (UUID runnerId : gameManager.getRunners()) {
            double distance;
            Player runner = Bukkit.getPlayer((UUID)runnerId);
            if (runner == null || !runner.isOnline() || !((distance = hunter.getLocation().distance(runner.getLocation())) < nearestDistance)) continue;
            nearestDistance = distance;
            nearest = runner;
        }
        return nearest;
    }
}

