/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.game;

import com.minecraft.manhunt.ManhuntPlugin;
import com.minecraft.manhunt.game.CompassManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GameManager {
    private final ManhuntPlugin plugin;
    private boolean gameRunning = false;
    private final Set<UUID> hunters = new HashSet<UUID>();
    private final Set<UUID> runners = new HashSet<UUID>();
    private final Set<UUID> spectators = new HashSet<UUID>();
    private BukkitTask gracePeriodTask;
    private BukkitTask suddenDeathTask;
    private int gracePeriodSeconds;
    private boolean inGracePeriod;

    public GameManager(ManhuntPlugin plugin) {
        this.plugin = plugin;
        this.gracePeriodSeconds = plugin.getConfigManager().getGracePeriod();
    }

    public void startGame() {
        if (this.gameRunning) {
            return;
        }
        if (!this.validateTeams()) {
            return;
        }
        this.gameRunning = true;
        this.inGracePeriod = true;
        this.setupPlayers();
        this.startGracePeriod();
        this.startSuddenDeathTimer();
        Bukkit.broadcastMessage((String)("\u00a7a[Manhunt] The hunt has begun! Runners have " + this.gracePeriodSeconds + " seconds head start!"));
    }

    public void endGame() {
        if (!this.gameRunning) {
            return;
        }
        this.gameRunning = false;
        this.inGracePeriod = false;
        if (this.gracePeriodTask != null) {
            this.gracePeriodTask.cancel();
        }
        if (this.suddenDeathTask != null) {
            this.suddenDeathTask.cancel();
        }
        this.resetPlayers();
        this.hunters.clear();
        this.runners.clear();
        this.spectators.clear();
        Bukkit.broadcastMessage((String)"\u00a7c[Manhunt] Game has ended!");
    }

    public void addHunter(Player player) {
        if (this.gameRunning) {
            player.sendMessage("\u00a7c[Manhunt] Cannot join while game is in progress!");
            return;
        }
        this.runners.remove(player.getUniqueId());
        this.spectators.remove(player.getUniqueId());
        this.hunters.add(player.getUniqueId());
        player.sendMessage("\u00a7a[Manhunt] You have joined as a Hunter!");
    }

    public void addRunner(Player player) {
        if (this.gameRunning) {
            player.sendMessage("\u00a7c[Manhunt] Cannot join while game is in progress!");
            return;
        }
        this.hunters.remove(player.getUniqueId());
        this.spectators.remove(player.getUniqueId());
        this.runners.add(player.getUniqueId());
        player.sendMessage("\u00a7a[Manhunt] You have joined as a Runner!");
    }

    public void addSpectator(Player player) {
        this.hunters.remove(player.getUniqueId());
        this.runners.remove(player.getUniqueId());
        this.spectators.add(player.getUniqueId());
        player.setGameMode(GameMode.SPECTATOR);
        player.sendMessage("\u00a7a[Manhunt] You are now spectating!");
    }

    private boolean validateTeams() {
        if (this.runners.isEmpty()) {
            Bukkit.broadcastMessage((String)"\u00a7c[Manhunt] Cannot start game without runners!");
            return false;
        }
        if (this.hunters.isEmpty()) {
            Bukkit.broadcastMessage((String)"\u00a7c[Manhunt] Cannot start game without hunters!");
            return false;
        }
        return true;
    }

    private void setupPlayers() {
        for (UUID hunterId : this.hunters) {
            Player hunter = Bukkit.getPlayer((UUID)hunterId);
            if (hunter == null) continue;
            hunter.setGameMode(GameMode.SURVIVAL);
            hunter.getInventory().clear();
            hunter.getInventory().addItem(new ItemStack[]{CompassManager.createTrackingCompass()});
        }
        for (UUID runnerId : this.runners) {
            Player runner = Bukkit.getPlayer((UUID)runnerId);
            if (runner == null) continue;
            runner.setGameMode(GameMode.SURVIVAL);
            runner.getInventory().clear();
        }
    }

    private void resetPlayers() {
        Player player;
        for (UUID playerId : this.hunters) {
            player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            player.setGameMode(GameMode.SURVIVAL);
            player.getInventory().clear();
        }
        for (UUID playerId : this.runners) {
            player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            player.setGameMode(GameMode.SURVIVAL);
            player.getInventory().clear();
        }
        for (UUID playerId : this.spectators) {
            player = Bukkit.getPlayer((UUID)playerId);
            if (player == null) continue;
            player.setGameMode(GameMode.SURVIVAL);
        }
    }

    private void startGracePeriod() {
        this.gracePeriodTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.inGracePeriod = false;
            Bukkit.broadcastMessage((String)"\u00a7c[Manhunt] Grace period has ended! The hunt is on!");
        }, (long)this.gracePeriodSeconds * 20L);
    }

    private void startSuddenDeathTimer() {
        int suddenDeathMinutes = this.plugin.getConfigManager().getSuddenDeathTime();
        this.suddenDeathTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.broadcastMessage((String)"\u00a7c[Manhunt] Sudden Death activated! All players receive damage boost!"), (long)(suddenDeathMinutes * 60) * 20L);
    }

    public boolean isHunter(Player player) {
        return this.hunters.contains(player.getUniqueId());
    }

    public boolean isRunner(Player player) {
        return this.runners.contains(player.getUniqueId());
    }

    public boolean isSpectator(Player player) {
        return this.spectators.contains(player.getUniqueId());
    }

    public boolean isGameRunning() {
        return this.gameRunning;
    }

    public Set<UUID> getHunters() {
        return this.hunters;
    }

    public Set<UUID> getRunners() {
        return this.runners;
    }

    public Set<UUID> getSpectators() {
        return this.spectators;
    }

    public int getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public boolean isInGracePeriod() {
        return this.inGracePeriod;
    }
}

