/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.listeners;

import com.minecraft.manhunt.ManhuntPlugin;
import com.minecraft.manhunt.game.CompassManager;
import org.bukkit.Bukkit;
import org.bukkit.advancement.Advancement;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;

public class AdvancementListener
implements Listener {
    private final ManhuntPlugin plugin;

    public AdvancementListener(ManhuntPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerAdvancement(PlayerAdvancementDoneEvent event) {
        String id;
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getGameManager().isRunner(player)) {
            return;
        }
        Advancement advancement = event.getAdvancement();
        switch (id = advancement.getKey().getKey()) {
            case "story/enter_the_nether": {
                Bukkit.broadcastMessage((String)("\u00a76\u00a7l" + player.getName() + " has entered the Nether!"));
                this.updateHunterCompasses(player);
                break;
            }
            case "story/enter_the_end": {
                Bukkit.broadcastMessage((String)("\u00a75\u00a7l" + player.getName() + " has entered The End!"));
                this.updateHunterCompasses(player);
                break;
            }
            case "story/mine_diamond": {
                Bukkit.broadcastMessage((String)("\u00a7b" + player.getName() + " has found diamonds!"));
                break;
            }
            case "nether/find_fortress": {
                Bukkit.broadcastMessage((String)("\u00a7c" + player.getName() + " has found a Nether Fortress!"));
                break;
            }
            case "nether/obtain_blaze_rod": {
                Bukkit.broadcastMessage((String)("\u00a76" + player.getName() + " has obtained a Blaze Rod!"));
                break;
            }
            case "story/follow_ender_eye": {
                Bukkit.broadcastMessage((String)("\u00a75" + player.getName() + " is tracking the Stronghold!"));
                break;
            }
            case "end/kill_dragon": {
                Bukkit.broadcastMessage((String)("\u00a7d\u00a7l" + player.getName() + " has defeated the Ender Dragon!"));
                this.plugin.getServer().broadcastMessage("\u00a76\u00a7lGame Over! Runners Win!");
                this.plugin.getGameManager().endGame();
            }
        }
    }

    private void updateHunterCompasses(Player runner) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.plugin.getGameManager().isHunter(player)) continue;
            CompassManager.updateCompass(player, runner);
        }
    }
}

