/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.listeners;

import com.minecraft.manhunt.ManhuntPlugin;
import com.minecraft.manhunt.game.CompassManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class CompassListener
implements Listener {
    private final ManhuntPlugin plugin;

    public CompassListener(ManhuntPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getGameManager().isHunter(player)) {
            return;
        }
        Action action = event.getAction();
        ItemStack item = event.getItem();
        if ((action == Action.RIGHT_CLICK_AIR || action == Action.RIGHT_CLICK_BLOCK) && CompassManager.isTrackingCompass(item)) {
            Player target = CompassManager.getNearestRunner(player);
            if (target != null) {
                CompassManager.updateCompass(player, target);
                player.sendMessage("\u00a7aTracking: " + target.getName());
            } else {
                player.sendMessage("\u00a7cNo runners found!");
            }
        }
    }
}

