/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.listeners;

import com.minecraft.manhunt.ManhuntPlugin;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;

public class GameListener
implements Listener {
    private final ManhuntPlugin plugin;

    public GameListener(ManhuntPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        ItemStack result;
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (!this.plugin.getConfigManager().isNetheriteEnabled() && (result = event.getRecipe().getResult()).getType().name().contains("NETHERITE")) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            player.sendMessage("\u00a7cNetherite crafting is disabled in this game!");
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        double damageBonus;
        if (!(this.plugin.getGameManager().isGameRunning() && event.getDamager() instanceof Player && event.getEntity() instanceof Player)) {
            return;
        }
        Player damager = (Player)event.getDamager();
        Player victim = (Player)event.getEntity();
        if (this.plugin.getGameManager().isInGracePeriod() && this.plugin.getGameManager().isHunter(damager) && this.plugin.getGameManager().isRunner(victim)) {
            event.setCancelled(true);
            damager.sendMessage("\u00a7cYou cannot damage runners during the grace period!");
        }
        if (this.plugin.getGameManager().isHunter(damager) && this.plugin.getGameManager().isHunter(victim)) {
            event.setCancelled(true);
            damager.sendMessage("\u00a7cYou cannot damage other hunters!");
        }
        if (this.plugin.getGameManager().isRunner(damager) && (damageBonus = this.plugin.getConfigManager().getRunnerHealthBonus()) > 0.0) {
            event.setDamage(event.getDamage() * (1.0 + damageBonus));
        }
    }
}

