/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.manhunt.listeners;

import com.minecraft.manhunt.ManhuntPlugin;
import com.minecraft.manhunt.game.CompassManager;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerListener
implements Listener {
    private final ManhuntPlugin plugin;

    public PlayerListener(ManhuntPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager().isGameRunning()) {
            this.plugin.getGameManager().addSpectator(player);
            player.sendMessage("\u00a7eA game is currently in progress. You've been set as a spectator.");
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getGameManager().isGameRunning()) {
            if (this.plugin.getGameManager().isRunner(player)) {
                this.plugin.getServer().broadcastMessage("\u00a7c" + player.getName() + " (Runner) has disconnected!");
            } else if (this.plugin.getGameManager().isHunter(player)) {
                this.plugin.getServer().broadcastMessage("\u00a7c" + player.getName() + " (Hunter) has disconnected!");
            }
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (this.plugin.getGameManager().isRunner(player)) {
            this.plugin.getServer().broadcastMessage("\u00a7c\u00a7lRunner " + player.getName() + " has been eliminated!");
            this.plugin.getGameManager().addSpectator(player);
            if (this.plugin.getGameManager().getRunners().isEmpty()) {
                this.plugin.getServer().broadcastMessage("\u00a76\u00a7lGame Over! Hunters Win!");
                this.plugin.getGameManager().endGame();
            }
        } else if (this.plugin.getGameManager().isHunter(player)) {
            this.plugin.getServer().broadcastMessage("\u00a7c\u00a7lHunter " + player.getName() + " has been eliminated!");
            if (this.plugin.getConfigManager().isHunterReviveEnabled()) {
                this.plugin.getServer().broadcastMessage("\u00a7e" + player.getName() + " will respawn in " + this.plugin.getConfigManager().getHunterReviveTime() + " seconds!");
            } else {
                this.plugin.getGameManager().addSpectator(player);
            }
        }
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (this.plugin.getGameManager().isHunter(player)) {
            player.getInventory().addItem(new ItemStack[]{CompassManager.createTrackingCompass()});
        }
    }
}

