/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.headhunters.feature;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.villagerunknown.headhunters.Headhunters;
import me.villagerunknown.platform.util.HeadUtil;
import me.villagerunknown.platform.util.MathUtil;
import me.villagerunknown.platform.util.StringUtil;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class headDropFeature {
    public static final float COMMON_DROP_CHANCE = Headhunters.CONFIG.commonDropChance;
    public static final float UNCOMMON_DROP_CHANCE = Headhunters.CONFIG.uncommonDropChance;
    public static final float RARE_DROP_CHANCE = Headhunters.CONFIG.rareDropChance;
    public static final float EPIC_DROP_CHANCE = Headhunters.CONFIG.epicDropChance;
    public static final float LEGENDARY_DROP_CHANCE = Headhunters.CONFIG.legendaryDropChance;
    public static final float ALWAYS_DROP_CHANCE = 1.0f;
    public static Map<String, Float> HEAD_DROPS = new HashMap<String, Float>(){
        {
            this.put("allay", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("armadillo", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("axolotl", Float.valueOf(RARE_DROP_CHANCE));
            this.put("lucy_axolotl", Float.valueOf(RARE_DROP_CHANCE));
            this.put("wild_axolotl", Float.valueOf(RARE_DROP_CHANCE));
            this.put("gold_axolotl", Float.valueOf(RARE_DROP_CHANCE));
            this.put("cyan_axolotl", Float.valueOf(RARE_DROP_CHANCE));
            this.put("blue_axolotl", Float.valueOf(1.0f));
            this.put("bat", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("bee", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("pollinated_bee", Float.valueOf(RARE_DROP_CHANCE));
            this.put("angry_bee", Float.valueOf(RARE_DROP_CHANCE));
            this.put("angry_pollinated_bee", Float.valueOf(RARE_DROP_CHANCE));
            this.put("blaze", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("bogged", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("breeze", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("camel", Float.valueOf(RARE_DROP_CHANCE));
            this.put("cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("tabby_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("tuxedo_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("ginger_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("siamese_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("british_shorthair_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("calico_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("persian_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("ragdoll_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("white_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("jellie_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("black_cat", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("cave_spider", Float.valueOf(RARE_DROP_CHANCE));
            this.put("chicken", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("cod", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("cow", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("creaking", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("creeper", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("charged_creeper", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("dolphin", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("donkey", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("dragon", Float.valueOf(1.0f));
            this.put("drowned", Float.valueOf(RARE_DROP_CHANCE));
            this.put("elder_guardian", Float.valueOf(1.0f));
            this.put("enderman", Float.valueOf(RARE_DROP_CHANCE));
            this.put("endermite", Float.valueOf(RARE_DROP_CHANCE));
            this.put("evoker", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("fox", Float.valueOf(RARE_DROP_CHANCE));
            this.put("snow_fox", Float.valueOf(RARE_DROP_CHANCE));
            this.put("red_fox", Float.valueOf(RARE_DROP_CHANCE));
            this.put("frog", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("cold_frog", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("temperate_frog", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("warm_frog", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("ghast", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("glow_squid", Float.valueOf(RARE_DROP_CHANCE));
            this.put("goat", Float.valueOf(RARE_DROP_CHANCE));
            this.put("screaming_goat", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("guardian", Float.valueOf(RARE_DROP_CHANCE));
            this.put("hoglin", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("white_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("creamy_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("chestnut_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("brown_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("black_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("gray_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("dark_brown_horse", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("husk", Float.valueOf(RARE_DROP_CHANCE));
            this.put("illusioner", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("iron_golem", Float.valueOf(RARE_DROP_CHANCE));
            this.put("llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("creamy_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("white_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("brown_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("gray_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("magma_cube", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("mooshroom", Float.valueOf(RARE_DROP_CHANCE));
            this.put("brown_mooshroom", Float.valueOf(RARE_DROP_CHANCE));
            this.put("red_mooshroom", Float.valueOf(RARE_DROP_CHANCE));
            this.put("mule", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("ocelot", Float.valueOf(RARE_DROP_CHANCE));
            this.put("panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("aggressive_panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("lazy_panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("playful_panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("worried_panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("brown_panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("weak_panda", Float.valueOf(RARE_DROP_CHANCE));
            this.put("parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("red_parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("blue_parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("green_parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("light_blue_parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("yellow_blue_parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("gray_parrot", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("phantom", Float.valueOf(RARE_DROP_CHANCE));
            this.put("pig", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("piglin", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("piglin_brute", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("pillager", Float.valueOf(RARE_DROP_CHANCE));
            this.put("polar_bear", Float.valueOf(RARE_DROP_CHANCE));
            this.put("pufferfish", Float.valueOf(RARE_DROP_CHANCE));
            this.put("rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("toast_rabbit", Float.valueOf(1.0f));
            this.put("brown_rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("white_rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("black_rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("black_and_white_rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("gold_rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("salt_and_pepper_rabbit", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("killer_rabbit", Float.valueOf(1.0f));
            this.put("ravager", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("salmon", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("shulker", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("black_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("blue_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("brown_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("cyan_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("gray_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("green_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("jeb_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("light_blue_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("light_gray_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("lime_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("magenta_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("orange_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("pink_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("purple_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("red_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("white_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("yellow_sheep", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("silverfish", Float.valueOf(RARE_DROP_CHANCE));
            this.put("skeleton", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("skeleton_horse", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("slime", Float.valueOf(RARE_DROP_CHANCE));
            this.put("sniffer", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("snow_golem", Float.valueOf(RARE_DROP_CHANCE));
            this.put("spider", Float.valueOf(RARE_DROP_CHANCE));
            this.put("squid", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("stray", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("strider", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("cold_strider", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("tadpole", Float.valueOf(RARE_DROP_CHANCE));
            this.put("trader_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("creamy_trader_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("white_trader_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("brown_trader_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("gray_trader_llama", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("tropical_fish", Float.valueOf(RARE_DROP_CHANCE));
            this.put("turtle", Float.valueOf(RARE_DROP_CHANCE));
            this.put("vex", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("angry_vex", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("armorer_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("butcher_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("cartographer_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("cleric_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("farmer_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("fisherman_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("fletcher_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("leatherworker_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("librarian_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("mason_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("nitwit_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("shepherd_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("toolsmith_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("weaponsmith_villager", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("vindicator", Float.valueOf(EPIC_DROP_CHANCE));
            this.put("wandering_trader", Float.valueOf(COMMON_DROP_CHANCE));
            this.put("warden", Float.valueOf(1.0f));
            this.put("witch", Float.valueOf(RARE_DROP_CHANCE));
            this.put("wither", Float.valueOf(1.0f));
            this.put("wither_projectile", Float.valueOf(1.0f));
            this.put("blue_wither_projectile", Float.valueOf(1.0f));
            this.put("wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("ashen_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_ashen_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("black_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_black_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("chestnut_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_chestnut_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("pale_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_pale_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("rusty_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_rusty_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("snowy_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_snowy_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("spotty_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_spotty_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("striped_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_striped_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("woods_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("angry_woods_wolf", Float.valueOf(UNCOMMON_DROP_CHANCE));
            this.put("zoglin", Float.valueOf(LEGENDARY_DROP_CHANCE));
            this.put("zombie", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_horse", Float.valueOf(1.0f));
            this.put("zombie_villager", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_armorer", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_butcher", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_cartographer", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_cleric", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_farmer", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_fisherman", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_fletcher", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_leatherworker", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_librarian", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_mason", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_nitwit", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_shepherd", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_toolsmith", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombie_weaponsmith", Float.valueOf(RARE_DROP_CHANCE));
            this.put("zombified_piglin", Float.valueOf(RARE_DROP_CHANCE));
        }
    };
    public static List<String> CREATIVE = List.of("illusioner", "zombie_horse");

    public static void execute() {
        headDropFeature.registerHeadDrop();
    }

    private static void registerHeadDrop() {
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, amount) -> {
            if (entity.method_31747() && MathUtil.hasChance((float)Headhunters.CONFIG.playerHeadDropChance)) {
                if (null != damageSource.method_5529() && damageSource.method_5529().method_31747()) {
                    entity.method_5775(entity.method_5682().method_3847(entity.method_37908().method_27983()), HeadUtil.getPlayerHeadStack((class_1657)((class_1657)entity)));
                }
            } else if (HEAD_DROPS.containsKey(entity.method_5864().method_35050())) {
                float dropChance;
                String id = entity.method_5864().method_35050();
                float modifiedDropChance = dropChance = HEAD_DROPS.get(id).floatValue();
                if (null != damageSource.method_5529() && damageSource.method_5529().method_31747()) {
                    class_1937 world = entity.method_37908();
                    class_1297 source = damageSource.method_5526();
                    if (null != source) {
                        class_1799 weapon = damageSource.method_60948();
                        if (null != weapon) {
                            class_1887 lootingEnchantment;
                            class_2378 registry;
                            class_6880 lootingEntry;
                            int enchantmentLevel;
                            class_9304 enchantments = class_1890.method_57532((class_1799)weapon);
                            class_5455 drm = world.method_30349();
                            if (null != drm && (enchantmentLevel = enchantments.method_57536(lootingEntry = (registry = drm.method_30530(class_7924.field_41265)).method_47983((Object)(lootingEnchantment = (class_1887)registry.method_29107(class_1893.field_9110))))) > 0) {
                                modifiedDropChance *= 1.0f + Headhunters.CONFIG.lootingBonusPerLevel * (float)enchantmentLevel;
                            }
                        }
                        if (MathUtil.hasChance((float)modifiedDropChance)) {
                            HeadUtil.Head head = HeadUtil.getHead((String)id);
                            class_1799 headStack = HeadUtil.buildHeadStack((class_1297)entity, (String)head.TEXTURE, (class_3414)head.NOTE_BLOCK_SOUND);
                            if (!headStack.method_7960()) {
                                headDropFeature.addRarityToStack(headStack, dropChance);
                                entity.method_5775(entity.method_5682().method_3847(entity.method_37908().method_27983()), headStack);
                            }
                        }
                    }
                }
            }
            return true;
        });
    }

    public static void addRarityToStack(class_1799 headStack, float dropChance) {
        class_1814 rarity = headDropFeature.getRarity(dropChance);
        headStack.method_57379(class_9334.field_50073, (Object)rarity);
        if (Headhunters.CONFIG.addRarityLoreToHeads) {
            String rarityString = class_1814.field_8906.name();
            if (UNCOMMON_DROP_CHANCE == dropChance) {
                rarityString = class_1814.field_8907.name();
            } else if (RARE_DROP_CHANCE == dropChance) {
                rarityString = class_1814.field_8903.name();
            } else if (EPIC_DROP_CHANCE == dropChance) {
                rarityString = class_1814.field_8904.name();
            } else if (LEGENDARY_DROP_CHANCE == dropChance || 1.0f == dropChance) {
                rarityString = "legendary";
            }
            headStack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_30163((String)StringUtil.capitalizeAll((String)rarityString.toLowerCase())))));
        }
    }

    @NotNull
    public static class_1814 getRarity(float dropChance) {
        class_1814 rarity = class_1814.field_8906;
        if (UNCOMMON_DROP_CHANCE == dropChance) {
            rarity = class_1814.field_8907;
        } else if (RARE_DROP_CHANCE == dropChance) {
            rarity = class_1814.field_8903;
        } else if (EPIC_DROP_CHANCE == dropChance || LEGENDARY_DROP_CHANCE == dropChance || 1.0f == dropChance) {
            rarity = class_1814.field_8904;
        }
        return rarity;
    }
}

