/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected;

import com.hlysine.create_connected.ConnectedLang;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CCTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return CCTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CCTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CCTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CCTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        Items.init();
    }

    public static enum Items {
        COPYCAT_BEAM(NameSpace.COPYCATS),
        COPYCAT_BLOCK(NameSpace.COPYCATS),
        COPYCAT_BOARD(NameSpace.COPYCATS),
        COPYCAT_BOX(NameSpace.COPYCATS),
        COPYCAT_CATWALK(NameSpace.COPYCATS),
        COPYCAT_FENCE(NameSpace.COPYCATS),
        COPYCAT_FENCE_GATE(NameSpace.COPYCATS),
        COPYCAT_SLAB(NameSpace.COPYCATS),
        COPYCAT_STAIRS(NameSpace.COPYCATS),
        COPYCAT_VERTICAL_STEP(NameSpace.COPYCATS),
        COPYCAT_WALL(NameSpace.COPYCATS);

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private Items() {
            this(NameSpace.MOD);
        }

        private Items(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Items(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private Items(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private Items(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? ConnectedLang.asId((String)this.name()) : path);
            this.tag = optional ? CCTags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create_connected", false, true),
        COPYCATS("copycats");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

