/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.board;

import com.google.common.collect.ImmutableMap;
import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.copycat.MigratingWaterloggedCopycatBlock;
import com.simibubi.create.api.schematic.requirement.SpecialBlockItemRequirement;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatBoardBlock
extends MigratingWaterloggedCopycatBlock
implements SpecialBlockItemRequirement {
    public static BooleanProperty UP = BlockStateProperties.UP;
    public static BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static BooleanProperty EAST = BlockStateProperties.EAST;
    public static BooleanProperty WEST = BlockStateProperties.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;

    public CopycatBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = this.getShapeForEachState(CopycatBoardBlock::calculateMultifaceShape);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST}));
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        return !reader.getBlockState(toPos).is((Block)this);
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        return reader.getBlockState(toPos).is((Block)this);
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        return (Boolean)state.getValue((Property)CopycatBoardBlock.byDirection(face.getOpposite())) == false;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    private static VoxelShape calculateMultifaceShape(BlockState pState) {
        VoxelShape shape = Shapes.empty();
        for (Direction direction : Iterate.directions) {
            if (!((Boolean)pState.getValue((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)CCShapes.CASING_1PX.get(direction));
        }
        return shape;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return Objects.requireNonNull((VoxelShape)this.shapesCache.get((Object)pState));
    }

    @Override
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState stateForPlacement = super.getStateForPlacement(context);
        assert (stateForPlacement != null);
        BlockPos blockPos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(blockPos);
        if (this.isSelfState(state)) {
            if (!((Boolean)state.getValue((Property)CopycatBoardBlock.byDirection(context.getClickedFace().getOpposite()))).booleanValue()) {
                return (BlockState)state.setValue((Property)CopycatBoardBlock.byDirection(context.getClickedFace().getOpposite()), (Comparable)Boolean.valueOf(true));
            }
            return (BlockState)state.setValue((Property)CopycatBoardBlock.byDirection(context.getClickedFace()), (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)stateForPlacement.setValue((Property)CopycatBoardBlock.byDirection(context.getClickedFace().getOpposite()), (Comparable)Boolean.valueOf(true));
    }

    public boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        ItemStack itemstack = pUseContext.getItemInHand();
        if (!itemstack.is(this.asItem())) {
            return false;
        }
        if (!((Boolean)pState.getValue((Property)CopycatBoardBlock.byDirection(pUseContext.getClickedFace().getOpposite()))).booleanValue()) {
            double loc;
            Direction direction = pUseContext.getClickedFace().getOpposite();
            double pos = CopycatBoardBlock.getByAxis((Vec3i)pUseContext.getClickedPos(), direction.getAxis());
            if (CopycatBoardBlock.getByAxis(direction.getNormal(), direction.getAxis()) > 0) {
                pos += 1.0;
            }
            if (Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((Position)pUseContext.getClickLocation(), direction.getAxis()))) < 0.125) {
                return true;
            }
        }
        if (!((Boolean)pState.getValue((Property)CopycatBoardBlock.byDirection(pUseContext.getClickedFace()))).booleanValue()) {
            double hitLoc = CopycatBoardBlock.getByAxis((Position)pUseContext.getClickLocation(), pUseContext.getClickedFace().getAxis());
            int direction = CopycatBoardBlock.getByAxis(pUseContext.getClickedFace().getNormal(), pUseContext.getClickedFace().getAxis());
            double offset = hitLoc - (double)Math.round(hitLoc);
            if (Mth.sign((double)direction) == Mth.sign((double)offset) && Math.abs(offset) < 0.125) {
                return true;
            }
        }
        return false;
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        int faceCount = 0;
        for (Direction direction : Iterate.directions) {
            if (!((Boolean)state.getValue((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            ++faceCount;
        }
        if (faceCount <= 1) {
            return super.onSneakWrenched(state, context);
        }
        ArrayList<Direction> options = new ArrayList<Direction>(6);
        for (Direction direction : Iterate.directions) {
            double loc;
            if (!((Boolean)state.getValue((Property)CopycatBoardBlock.byDirection(direction))).booleanValue()) continue;
            double pos = CopycatBoardBlock.getByAxis((Vec3i)context.getClickedPos(), direction.getAxis());
            if (CopycatBoardBlock.getByAxis(direction.getNormal(), direction.getAxis()) > 0) {
                pos += 1.0;
            }
            if (!(Math.abs(pos - (loc = CopycatBoardBlock.getByAxis((Position)context.getClickLocation(), direction.getAxis()))) < 0.125)) continue;
            options.add(direction);
        }
        if (options.size() > 1) {
            Direction backup = (Direction)options.get(0);
            options.removeIf(d -> d.getAxis() != context.getClickedFace().getAxis());
            if (options.size() == 0) {
                options.add(backup);
            }
        }
        if (options.size() == 0) {
            return super.onSneakWrenched(state, context);
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (world instanceof ServerLevel) {
            if (player != null && !player.isCreative()) {
                List drops = Block.getDrops((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CopycatBoardBlock.byDirection((Direction)options.get(0)), (Comparable)Boolean.valueOf(true))), (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand());
                for (ItemStack drop : drops) {
                    player.getInventory().placeItemBackInInventory(drop);
                }
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)CopycatBoardBlock.byDirection((Direction)options.get(0)), (Comparable)Boolean.valueOf(false)));
            IWrenchable.playRemoveSound((Level)world, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    public ItemRequirement getRequiredItems(BlockState state, BlockEntity blockEntity) {
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, new ItemStack((ItemLike)this.asItem(), (int)Arrays.stream(Iterate.directions).filter(d -> (Boolean)state.getValue((Property)CopycatBoardBlock.byDirection(d))).count()));
    }

    private static int getByAxis(Vec3i pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> pos.getX();
            case Direction.Axis.Y -> pos.getY();
            case Direction.Axis.Z -> pos.getZ();
        };
    }

    private static double getByAxis(Position pos, Direction.Axis axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> pos.x();
            case Direction.Axis.Y -> pos.y();
            case Direction.Axis.Z -> pos.z();
        };
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.is((Block)this) && !((Boolean)state.getValue((Property)CopycatBoardBlock.byDirection(dir))).booleanValue()) {
            return false;
        }
        if (neighborState.is((Block)this) && !((Boolean)neighborState.getValue((Property)CopycatBoardBlock.byDirection(dir.getOpposite()))).booleanValue()) {
            return false;
        }
        if (state.is((Block)this) == neighborState.is((Block)this)) {
            return CopycatBoardBlock.getMaterial((BlockGetter)level, (BlockPos)pos).skipRendering(CopycatBoardBlock.getMaterial((BlockGetter)level, (BlockPos)pos.relative(dir)), dir.getOpposite());
        }
        return CopycatBoardBlock.getMaterial((BlockGetter)level, (BlockPos)pos).skipRendering(neighborState, dir.getOpposite());
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, Rotation pRotation) {
        return this.mapDirections(pState, arg_0 -> ((Rotation)pRotation).rotate(arg_0));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, Mirror pMirror) {
        return this.mapDirections(pState, arg_0 -> ((Mirror)pMirror).mirror(arg_0));
    }

    private BlockState mapDirections(BlockState pState, Function<Direction, Direction> pDirectionalFunction) {
        BlockState blockstate = pState;
        for (Direction direction : Iterate.directions) {
            blockstate = (BlockState)blockstate.setValue((Property)CopycatBoardBlock.byDirection(pDirectionalFunction.apply(direction)), (Comparable)((Boolean)pState.getValue((Property)CopycatBoardBlock.byDirection(direction))));
        }
        return blockstate;
    }

    public static BooleanProperty byDirection(Direction direction) {
        return PROPERTY_BY_DIRECTION.get(direction);
    }
}

