/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.stairs;

import com.hlysine.create_connected.content.copycat.ICopycatWithWrappedBlock;
import com.hlysine.create_connected.content.copycat.WaterloggedCopycatWrappedBlock;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopycatStairsBlock
extends WaterloggedCopycatWrappedBlock {
    public static StairBlock stairs;

    public CopycatStairsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)StairBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)StairBlock.HALF, (Comparable)Half.BOTTOM)).setValue((Property)StairBlock.SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    @Override
    public Block getWrappedBlock() {
        return stairs;
    }

    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{StairBlock.FACING, StairBlock.HALF, StairBlock.SHAPE}));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext pContext) {
        BlockState state = stairs.getStateForPlacement(pContext);
        if (state == null) {
            return super.getStateForPlacement(pContext);
        }
        return ICopycatWithWrappedBlock.copyState(state, super.getStateForPlacement(pContext), false);
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).getShape(pLevel, pPos, pContext);
    }

    public void attack(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer) {
        ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).attack(pLevel, pPos, pPlayer);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public void onPlace(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pOldState, boolean pIsMoving) {
        ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).onPlace(pLevel, pPos, pOldState, pIsMoving);
    }

    @Override
    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).onRemove(pLevel, pPos, pNewState, pIsMoving);
    }

    public boolean isRandomlyTicking(@NotNull BlockState pState) {
        return ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).isRandomlyTicking();
    }

    public void randomTick(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).randomTick(pLevel, pPos, pRandom);
    }

    public void tick(@NotNull BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).tick(pLevel, pPos, pRandom);
    }

    @Override
    @NotNull
    public BlockState updateShape(@NotNull BlockState pState, @NotNull Direction pDirection, @NotNull BlockState pNeighborState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pNeighborPos) {
        return CopycatStairsBlock.migrateOnUpdate(pLevel.isClientSide(), ICopycatWithWrappedBlock.unwrapForOperation((Block)stairs, pState, state -> state.updateShape(pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos)));
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, @NotNull Rotation pRotation) {
        return ICopycatWithWrappedBlock.unwrapForOperation((Block)stairs, pState, state -> state.rotate(pRotation));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        return ICopycatWithWrappedBlock.unwrapForOperation((Block)stairs, pState, state -> state.mirror(pMirror));
    }

    protected boolean isPathfindable(@NotNull BlockState pState, @NotNull PathComputationType pPathComputationType) {
        return ICopycatWithWrappedBlock.wrappedState((Block)stairs, pState).isPathfindable(pPathComputationType);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        boolean flipped = state.getValue((Property)StairBlock.HALF) == Half.TOP;
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        BlockState toState = reader.getBlockState(toPos);
        BlockPos diff = toPos.subtract((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.ZERO)) {
            return true;
        }
        Direction side = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (toState.is((Block)this)) {
            return false;
        }
        if (diff.getY() == 0) {
            int fullCount = 0;
            if (diff.getX() != 0 && CopycatStairsBlock.getFaceShape(state, Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)CopycatStairsBlock.directionOf(diff.getX()))).isFull()) {
                ++fullCount;
            }
            if (diff.getZ() != 0 && CopycatStairsBlock.getFaceShape(state, Direction.fromAxisAndDirection((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)CopycatStairsBlock.directionOf(diff.getZ()))).isFull()) {
                ++fullCount;
            }
            return fullCount == 0;
        }
        return diff.getY() > 0 != flipped;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        BlockState toState = reader.getBlockState(toPos);
        BlockPos diff = toPos.subtract((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.ZERO)) {
            return true;
        }
        Direction side = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (side != null) {
            FaceShape sideShape = CopycatStairsBlock.getFaceShape(state, side);
            if (!sideShape.canConnect()) {
                return false;
            }
            if (toState.is((Block)this) ? !sideShape.equals(CopycatStairsBlock.getFaceShape(toState, side.getOpposite())) : !sideShape.isFull()) {
                return false;
            }
        }
        return true;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        int count = CopycatStairsBlock.getFaceShape(state, face).countBlocks();
        return count == 4 || count == 3 && state.getValue((Property)StairBlock.SHAPE) == StairsShape.STRAIGHT;
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if ((neighborState.getBlock() instanceof StairBlock || neighborState.getBlock() instanceof CopycatStairsBlock) && CopycatStairsBlock.getMaterial(level, pos).skipRendering(CopycatStairsBlock.getMaterial(level, pos.relative(dir)), dir.getOpposite())) {
            return CopycatStairsBlock.getFaceShape(state, dir).equals(CopycatStairsBlock.getFaceShape(neighborState, dir.getOpposite()));
        }
        return CopycatStairsBlock.getFaceShape(state, dir).isFull() && CopycatStairsBlock.getMaterial(level, pos).skipRendering(neighborState, dir.getOpposite());
    }

    public static BlockState getMaterial(BlockGetter reader, BlockPos targetPos) {
        BlockState state = CopycatBlock.getMaterial((BlockGetter)reader, (BlockPos)targetPos);
        if (state.is(Blocks.AIR)) {
            return reader.getBlockState(targetPos);
        }
        return state;
    }

    private static Direction.AxisDirection directionOf(int value) {
        return value >= 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE;
    }

    public static FaceShape getFaceShape(BlockState state, Direction face) {
        boolean top = state.getValue((Property)StairBlock.HALF) == Half.TOP;
        Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
        StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
        if (!top && face == Direction.DOWN) {
            return new FaceShape().fillAll();
        }
        if (top && face == Direction.UP) {
            return new FaceShape().fillAll();
        }
        FaceShape faceShape = new FaceShape();
        switch (shape) {
            case STRAIGHT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop().rotate(facing.toYRot());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top);
                }
                if (face == facing.getOpposite()) {
                    return faceShape;
                }
                return faceShape.fillRow(!top, facing.getAxisDirection());
            }
            case INNER_LEFT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop().fillBottom(Direction.AxisDirection.POSITIVE).rotate(facing.toYRot());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top);
                }
                if (face == facing.getOpposite()) {
                    return faceShape.fillRow(!top, facing.getCounterClockWise().getAxisDirection());
                }
                if (face == facing.getCounterClockWise()) {
                    return faceShape.fillRow(!top);
                }
                if (face != facing.getClockWise()) break;
                return faceShape.fillRow(!top, facing.getAxisDirection());
            }
            case INNER_RIGHT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop().fillBottom(Direction.AxisDirection.NEGATIVE).rotate(facing.toYRot());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top);
                }
                if (face == facing.getOpposite()) {
                    return faceShape.fillRow(!top, facing.getClockWise().getAxisDirection());
                }
                if (face == facing.getClockWise()) {
                    return faceShape.fillRow(!top);
                }
                if (face != facing.getCounterClockWise()) break;
                return faceShape.fillRow(!top, facing.getAxisDirection());
            }
            case OUTER_LEFT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop(Direction.AxisDirection.POSITIVE).rotate(facing.toYRot());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top, facing.getCounterClockWise().getAxisDirection());
                }
                if (face == facing.getOpposite()) {
                    return faceShape;
                }
                if (face == facing.getCounterClockWise()) {
                    return faceShape.fillRow(!top, facing.getAxisDirection());
                }
                if (face != facing.getClockWise()) break;
                return faceShape;
            }
            case OUTER_RIGHT: {
                if (!top && face == Direction.UP || top && face == Direction.DOWN) {
                    return faceShape.fillTop(Direction.AxisDirection.NEGATIVE).rotate(facing.toYRot());
                }
                faceShape.fillRow(top);
                if (face == facing) {
                    return faceShape.fillRow(!top, facing.getClockWise().getAxisDirection());
                }
                if (face == facing.getOpposite()) {
                    return faceShape;
                }
                if (face == facing.getClockWise()) {
                    return faceShape.fillRow(!top, facing.getAxisDirection());
                }
                if (face != facing.getCounterClockWise()) break;
                return faceShape;
            }
        }
        return faceShape;
    }

    private static class FaceShape {
        public boolean topNegative;
        public boolean topPositive;
        public boolean bottomNegative;
        public boolean bottomPositive;

        private FaceShape() {
        }

        public FaceShape fillTop() {
            this.topPositive = true;
            this.topNegative = true;
            return this;
        }

        public FaceShape fillTop(Direction.AxisDirection direction) {
            switch (direction) {
                case POSITIVE: {
                    this.topPositive = true;
                    break;
                }
                case NEGATIVE: {
                    this.topNegative = true;
                }
            }
            return this;
        }

        public FaceShape fillBottom() {
            this.bottomPositive = true;
            this.bottomNegative = true;
            return this;
        }

        public FaceShape fillBottom(Direction.AxisDirection direction) {
            switch (direction) {
                case POSITIVE: {
                    this.bottomPositive = true;
                    break;
                }
                case NEGATIVE: {
                    this.bottomNegative = true;
                }
            }
            return this;
        }

        public FaceShape fillRow(boolean top) {
            if (top) {
                return this.fillTop();
            }
            return this.fillBottom();
        }

        public FaceShape fillRow(boolean top, Direction.AxisDirection direction) {
            if (top) {
                return this.fillTop(direction);
            }
            return this.fillBottom(direction);
        }

        public FaceShape fillAll() {
            return this.fillTop().fillBottom();
        }

        public FaceShape rotate(float angle) {
            return this.rotate((int)angle);
        }

        public FaceShape rotate(int angle) {
            if ((angle %= 360) < 0) {
                angle += 360;
            }
            return switch (angle) {
                case 90 -> this.set(this.topNegative, this.bottomNegative, this.topPositive, this.bottomPositive);
                case 180 -> this.set(this.topPositive, this.topNegative, this.bottomPositive, this.bottomNegative);
                case 270 -> this.set(this.bottomPositive, this.topPositive, this.bottomNegative, this.topNegative);
                default -> this;
            };
        }

        public FaceShape set(boolean bottomNegative, boolean bottomPositive, boolean topNegative, boolean topPositive) {
            this.bottomNegative = bottomNegative;
            this.bottomPositive = bottomPositive;
            this.topNegative = topNegative;
            this.topPositive = topPositive;
            return this;
        }

        public int countBlocks() {
            int count = 0;
            if (this.bottomNegative) {
                ++count;
            }
            if (this.bottomPositive) {
                ++count;
            }
            if (this.topNegative) {
                ++count;
            }
            if (this.topPositive) {
                ++count;
            }
            return count;
        }

        public boolean canConnect() {
            return this.countBlocks() >= 3;
        }

        public boolean isFull() {
            return this.countBlocks() == 4;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FaceShape)) {
                return false;
            }
            FaceShape shape = (FaceShape)obj;
            return shape.bottomNegative == this.bottomNegative && shape.bottomPositive == this.bottomPositive && shape.topNegative == this.topNegative && shape.topPositive == this.topPositive;
        }
    }
}

