/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.verticalstep;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.copycat.MigratingWaterloggedCopycatBlock;
import com.simibubi.create.foundation.placement.PoleHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CopycatVerticalStepBlock
extends MigratingWaterloggedCopycatBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    private static final Map<Pair<Integer, Integer>, Direction> VERTICAL_POSITION_MAP = new HashMap<Pair<Integer, Integer>, Direction>();
    private static final Map<Pair<Direction, Integer>, Direction> HORIZONTAL_POSITION_MAP = new HashMap<Pair<Direction, Integer>, Direction>();

    public CopycatVerticalStepBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!player.isShiftKeyDown() && player.mayBuild()) {
            ItemStack heldItem = player.getItemInHand(hand);
            IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
            if (placementHelper.matchesItem(heldItem)) {
                placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)heldItem.getItem(), player, hand, hitResult);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public boolean isIgnoredConnectivitySide(BlockAndTintGetter reader, BlockState state, Direction face, BlockPos fromPos, BlockPos toPos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState toState = reader.getBlockState(toPos);
        if (toState.is((Block)this)) {
            return toState.getValue((Property)FACING) != direction;
        }
        return true;
    }

    public boolean canConnectTexturesToward(BlockAndTintGetter reader, BlockPos fromPos, BlockPos toPos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockState toState = reader.getBlockState(toPos);
        BlockPos diff = toPos.subtract((Vec3i)fromPos);
        if (diff.equals((Object)Vec3i.ZERO)) {
            return true;
        }
        Direction face = Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
        if (face == null) {
            return false;
        }
        if (toState.is((Block)this)) {
            return toState.getValue((Property)FACING) == facing && face.getAxis() == Direction.Axis.Y;
        }
        return false;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    public boolean canFaceBeOccluded(BlockState state, Direction face) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return face.getAxis() == Direction.Axis.Y || face == facing || face == facing.getCounterClockWise();
    }

    public boolean shouldFaceAlwaysRender(BlockState state, Direction face) {
        return !this.canFaceBeOccluded(state, face);
    }

    @Override
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        int zOffset;
        BlockState stateForPlacement = super.getStateForPlacement(context);
        assert (stateForPlacement != null);
        int xOffset = context.getClickLocation().x - (double)context.getClickedPos().getX() > 0.5 ? 1 : -1;
        int n = zOffset = context.getClickLocation().z - (double)context.getClickedPos().getZ() > 0.5 ? 1 : -1;
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)VERTICAL_POSITION_MAP.get(Pair.of((Object)xOffset, (Object)zOffset)));
        }
        return (BlockState)stateForPlacement.setValue((Property)FACING, (Comparable)HORIZONTAL_POSITION_MAP.get(Pair.of((Object)context.getClickedFace(), (Object)(context.getClickedFace().getAxis() == Direction.Axis.X ? zOffset : xOffset))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder.add(new Property[]{FACING}));
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return CCShapes.CASING_8PX_VERTICAL.get((Direction)pState.getValue((Property)FACING));
    }

    public boolean supportsExternalFaceHiding(BlockState state) {
        return true;
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        if (state.is((Block)this) == neighborState.is((Block)this) && CopycatVerticalStepBlock.getMaterial((BlockGetter)level, (BlockPos)pos).skipRendering(CopycatVerticalStepBlock.getMaterial((BlockGetter)level, (BlockPos)pos.relative(dir)), dir.getOpposite())) {
            return dir.getAxis().isVertical() && neighborState.getValue((Property)FACING) == state.getValue((Property)FACING);
        }
        return false;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState pState, @NotNull Mirror pMirror) {
        Direction.Axis mirrorAxis = null;
        for (Direction.Axis axis : Iterate.axes) {
            if (!pMirror.rotation().inverts(axis)) continue;
            mirrorAxis = axis;
            break;
        }
        if (mirrorAxis == null || mirrorAxis.isVertical()) {
            return super.mirror(pState, pMirror);
        }
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if (facing.getAxis() != mirrorAxis) {
            return (BlockState)pState.setValue((Property)FACING, (Comparable)facing.getClockWise());
        }
        return (BlockState)pState.setValue((Property)FACING, (Comparable)facing.getCounterClockWise());
    }

    static {
        for (Direction main : Iterate.horizontalDirections) {
            Direction cross = main.getCounterClockWise();
            int mainOffset = main.getAxisDirection().getStep();
            int crossOffset = cross.getAxisDirection().getStep();
            if (main.getAxis() == Direction.Axis.X) {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)mainOffset, (Object)crossOffset), main);
            } else {
                VERTICAL_POSITION_MAP.put((Pair<Integer, Integer>)Pair.of((Object)crossOffset, (Object)mainOffset), main);
            }
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)main.getOpposite(), (Object)crossOffset), main);
            HORIZONTAL_POSITION_MAP.put((Pair<Direction, Integer>)Pair.of((Object)cross.getOpposite(), (Object)mainOffset), main);
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction> {
        private PlacementHelper() {
            super(arg_0 -> CCBlocks.COPYCAT_VERTICAL_STEP.has(arg_0), $ -> Direction.Axis.Y, (Property)FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> i.getItem() instanceof BlockItem && ((BlockItem)i.getItem()).getBlock() instanceof CopycatVerticalStepBlock;
        }
    }
}

