/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.copycat.verticalstep;

import com.hlysine.create_connected.content.copycat.verticalstep.CopycatVerticalStepBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CopycatVerticalStepModel
extends CopycatModel {
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);

    public CopycatVerticalStepModel(BakedModel originalModel) {
        super(originalModel);
    }

    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        Direction facing = state.getOptionalValue((Property)CopycatVerticalStepBlock.FACING).orElse(Direction.NORTH);
        Direction perpendicular = facing.getCounterClockWise();
        int xOffset = (facing.getAxis() == Direction.Axis.X ? facing : perpendicular).getAxisDirection().getStep();
        int zOffset = (facing.getAxis() == Direction.Axis.Z ? facing : perpendicular).getAxisDirection().getStep();
        BakedModel model = CopycatVerticalStepModel.getModelOf((BlockState)material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 rowNormal = new Vec3(1.0, 0.0, 0.0);
        Vec3 columnNormal = new Vec3(0.0, 0.0, 1.0);
        AABB bb = CUBE_AABB.contract(0.75, 0.0, 0.75);
        for (boolean row : Iterate.trueAndFalse) {
            for (boolean column : Iterate.trueAndFalse) {
                AABB bb1 = bb;
                if (row) {
                    bb1 = bb1.move(rowNormal.scale(0.75));
                }
                if (column) {
                    bb1 = bb1.move(columnNormal.scale(0.75));
                }
                Vec3 offset = Vec3.ZERO;
                Vec3 rowShift = rowNormal.scale(row ? (double)(8 * Mth.clamp((int)xOffset, (int)-1, (int)0)) / 16.0 : (double)(8 * Mth.clamp((int)xOffset, (int)0, (int)1)) / 16.0);
                Vec3 columnShift = columnNormal.scale(column ? (double)(8 * Mth.clamp((int)zOffset, (int)-1, (int)0)) / 16.0 : (double)(8 * Mth.clamp((int)zOffset, (int)0, (int)1)) / 16.0);
                offset = offset.add(rowShift);
                offset = offset.add(columnShift);
                rowShift = rowShift.normalize();
                columnShift = columnShift.normalize();
                Vec3i rowShiftNormal = new Vec3i((int)rowShift.x, (int)rowShift.y, (int)rowShift.z);
                Vec3i columnShiftNormal = new Vec3i((int)columnShift.x, (int)columnShift.y, (int)columnShift.z);
                for (int i = 0; i < size; ++i) {
                    BakedQuad quad = (BakedQuad)templateQuads.get(i);
                    Direction direction = quad.getDirection();
                    if (direction.getAxis() == Direction.Axis.X && row == (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE) || direction.getAxis() == Direction.Axis.Z && column == (direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE)) continue;
                    quads.add(BakedQuadHelper.cloneWithCustomGeometry((BakedQuad)quad, (int[])BakedModelHelper.cropAndMove((int[])quad.getVertices(), (TextureAtlasSprite)quad.getSprite(), (AABB)bb1, (Vec3)offset)));
                }
            }
        }
        return quads;
    }
}

