/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.linkedtransmitter;

import com.hlysine.create_connected.content.linkedtransmitter.LinkedButtonBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class LinkedTransmitterFrequencySlot
extends ValueBoxTransform.Dual {
    public LinkedTransmitterFrequencySlot(boolean first) {
        super(first);
    }

    public boolean shouldRender(LevelAccessor level, BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LOCKED) == false && super.shouldRender(level, pos, state);
    }

    public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
        return (Boolean)state.getValue((Property)BlockStateProperties.LOCKED) == false && super.testHit(level, pos, state, localHit);
    }

    public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)LinkedButtonBlock.FACING);
        AttachFace face = (AttachFace)state.getValue((Property)LinkedButtonBlock.FACE);
        Vec3 location = switch (face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> VecHelper.voxelSpace((double)2.5, (double)1.1f, (double)10.5).add(this.isFirst() ? Vec3.ZERO : VecHelper.voxelSpace((double)0.0, (double)0.0, (double)-5.0));
            case AttachFace.WALL -> VecHelper.voxelSpace((double)13.5, (double)10.5, (double)1.1f).add(this.isFirst() ? Vec3.ZERO : VecHelper.voxelSpace((double)0.0, (double)-5.0, (double)0.0));
            case AttachFace.CEILING -> VecHelper.voxelSpace((double)2.5, (double)14.9f, (double)5.5).add(this.isFirst() ? Vec3.ZERO : VecHelper.voxelSpace((double)0.0, (double)0.0, (double)5.0));
        };
        location = VecHelper.rotateCentered((Vec3)location, (double)AngleHelper.horizontalAngle((Direction)facing), (Direction.Axis)Direction.Axis.Y);
        return location;
    }

    public void rotate(LevelAccessor level, BlockPos pos, BlockState state, PoseStack ms) {
        Direction facing = (Direction)state.getValue((Property)LinkedButtonBlock.FACING);
        AttachFace face = (AttachFace)state.getValue((Property)LinkedButtonBlock.FACE);
        float yRot = AngleHelper.horizontalAngle((Direction)facing) + (float)(face != AttachFace.WALL ? 0 : 180);
        float xRot = face == AttachFace.FLOOR ? 90.0f : (face == AttachFace.CEILING ? 270.0f : 0.0f);
        ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
    }

    public float getScale() {
        return 0.4975f;
    }
}

